/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.transformation.dataset;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequenceTarget;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.datatype.SequencesGroupBuilder;
import org.sing_group.seda.datatype.SequencesGroupDataset;
import org.sing_group.seda.transformation.dataset.SequencesGroupDatasetTransformation;

public class CompareSequencesGroupDatasetTransformation
implements SequencesGroupDatasetTransformation {
    private final Function<SequencesGroup[], SequencesGroupDataset> builder = factory::newSequencesGroupDataset;
    private final SequencesGroupBuilder groupBuilder = factory::newSequencesGroup;
    private SequenceTarget sequenceTarget;

    public CompareSequencesGroupDatasetTransformation(SequenceTarget sequenceTarget) {
        this(sequenceTarget, DatatypeFactory.getDefaultDatatypeFactory());
    }

    public CompareSequencesGroupDatasetTransformation(SequenceTarget sequenceTarget, DatatypeFactory factory) {
        this.sequenceTarget = sequenceTarget;
    }

    @Override
    public SequencesGroupDataset transform(SequencesGroupDataset dataset) {
        ArrayList<SequencesGroup> result = new ArrayList<SequencesGroup>();
        List sequencesGroups = dataset.getSequencesGroups().collect(Collectors.toList());
        for (int i = 0; i < sequencesGroups.size() - 1; ++i) {
            SequencesGroup A = (SequencesGroup)sequencesGroups.get(i);
            for (int j = i + 1; j < sequencesGroups.size(); ++j) {
                SequencesGroup B = (SequencesGroup)sequencesGroups.get(j);
                Stream<Sequence> onlyA = A.getSequences().filter(sequenceA -> B.getSequences().noneMatch(sequenceB -> CompareSequencesGroupDatasetTransformation.filter(sequenceA, sequenceB, this.sequenceTarget)));
                Stream<Sequence> onlyB = B.getSequences().filter(sequenceB -> A.getSequences().noneMatch(sequenceA -> CompareSequencesGroupDatasetTransformation.filter(sequenceA, sequenceB, this.sequenceTarget)));
                Stream<Sequence> both = A.getSequences().filter(sequenceA -> B.getSequences().anyMatch(sequenceB -> CompareSequencesGroupDatasetTransformation.filter(sequenceA, sequenceB, this.sequenceTarget)));
                result.add(this.groupBuilder.of(A.getName() + "_vs_" + B.getName() + "_only_" + A.getName() + ".fasta", this.getDatasetPropertiesMap(dataset), onlyA.collect(Collectors.toList())));
                result.add(this.groupBuilder.of(A.getName() + "_vs_" + B.getName() + "_only_" + B.getName() + ".fasta", this.getDatasetPropertiesMap(dataset), onlyB.collect(Collectors.toList())));
                result.add(this.groupBuilder.of(A.getName() + "_vs_" + B.getName() + "_both.fasta", this.getDatasetPropertiesMap(dataset), both.collect(Collectors.toList())));
            }
        }
        return this.builder.apply(result.toArray(new SequencesGroup[0]));
    }

    private static boolean filter(Sequence sequenceA, Sequence sequenceB, SequenceTarget sequenceTarget) {
        switch (sequenceTarget) {
            case HEADER: {
                return sequenceA.getHeader().equals(sequenceB.getHeader());
            }
            case SEQUENCE: {
                return sequenceA.getChain().equals(sequenceB.getChain());
            }
        }
        throw new IllegalStateException("Unknown SequenceTarget enum value.");
    }
}

