/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui.configuration_panel.rename;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.gc4s.input.RadioButtonsPanel;
import org.sing_group.gc4s.ui.CardsPanel;
import org.sing_group.gc4s.ui.CardsPanelBuilder;
import org.sing_group.gc4s.ui.CenteredJPanel;
import org.sing_group.gc4s.ui.text.MultilineLabel;
import org.sing_group.seda.core.SedaContext;
import org.sing_group.seda.core.SedaContextEvent;
import org.sing_group.seda.core.rename.AddStringHeaderRenamer;
import org.sing_group.seda.core.rename.FieldSplitRenamer;
import org.sing_group.seda.core.rename.HeaderRenamer;
import org.sing_group.seda.core.rename.HeaderTarget;
import org.sing_group.seda.core.rename.IntervalReplaceRenamer;
import org.sing_group.seda.core.rename.WordReplaceRenamer;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.gui.HtmlMessage;
import org.sing_group.seda.gui.configuration_panel.rename.AbstractRenameHeaderPanel;
import org.sing_group.seda.gui.configuration_panel.rename.AddStringHeaderRenamePanel;
import org.sing_group.seda.gui.configuration_panel.rename.FieldSplitRenamePanel;
import org.sing_group.seda.gui.configuration_panel.rename.IntervalReplaceRenamePanel;
import org.sing_group.seda.gui.configuration_panel.rename.RenamePanelEventListener;
import org.sing_group.seda.gui.configuration_panel.rename.WordReplaceRenamePanel;
import org.sing_group.seda.plugin.core.info.plugin.RenameHeaderSedaPluginInfo;
import org.sing_group.seda.transformation.provider.rename.RenameHeaderTransformationProvider;

public class RenameHeaderTransformationConfigurationPanel
extends AbstractRenameHeaderPanel
implements RenamePanelEventListener {
    private static final long serialVersionUID = 1L;
    private static final String NO_PREVIEW_SEQ_AVAILABLE = "No file selected";
    private static final String INVALID_CONFIGURATION = "Invalid rename configuration";
    private static final Comparator<? super String> PATH_SIZE_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            long diff = new File(o1).length() - new File(o2).length();
            if (diff < 0L) {
                return -1;
            }
            if (diff > 0L) {
                return 1;
            }
            return 0;
        }
    };
    private RadioButtonsPanel<HeaderTarget> headerTargetRbtnPanel;
    private CardsPanel cardsPanel;
    private SedaContext sedaContext;
    private MultilineLabel currentSampleLabel;
    private MultilineLabel currentPreviewLabel;
    private Sequence sampleSequence;
    private String currentPath;
    private RenameHeaderTransformationProvider transformationProvider;

    public RenameHeaderTransformationConfigurationPanel() {
        this.init();
        this.initTransformationProvider();
    }

    private void init() {
        this.add((Component)new CenteredJPanel((Component)this.getMainPanel()));
    }

    private JPanel getMainPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(this.getPreviewPanel());
        mainPanel.add(this.getHeaderTargetPanel());
        mainPanel.add(this.getConfigurationPanel());
        return mainPanel;
    }

    private Component getHeaderTargetPanel() {
        return new InputParametersPanel(new InputParameter[]{this.getHeaderTargetParameter()});
    }

    private InputParameter getHeaderTargetParameter() {
        this.headerTargetRbtnPanel = new RadioButtonsPanel((Object[])HeaderTarget.values(), 1, 2);
        this.headerTargetRbtnPanel.addItemListener(this::headerTargetValueChanged);
        return new InputParameter("Target: ", this.headerTargetRbtnPanel, RenameHeaderSedaPluginInfo.PARAM_TARGET_HELP_GUI);
    }

    private void headerTargetValueChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.onRenameConfigurationChanged(this);
        }
    }

    private Component getConfigurationPanel() {
        CardsPanelBuilder builder = new CardsPanelBuilder().withSelectionLabel("Rename type:");
        for (Rename rename : Rename.values()) {
            rename.getPanel().addRenamePanelEventListener(this);
            builder.withCard((Object)rename, (Component)rename.getPanel());
        }
        this.cardsPanel = builder.build();
        this.cardsPanel.addPropertyChangeListener("gc4s.cardspanel.visiblecard", this::selectedCardChanged);
        return this.cardsPanel;
    }

    private void selectedCardChanged(PropertyChangeEvent evt) {
        this.onRenameConfigurationChanged(this);
    }

    private Component getPreviewPanel() {
        JLabel sampleLabel = new JLabel("Sample: ");
        this.currentSampleLabel = new MultilineLabel(NO_PREVIEW_SEQ_AVAILABLE);
        this.currentSampleLabel.setColumns(50);
        JLabel previewLabel = new JLabel("Preview: ");
        this.currentPreviewLabel = new MultilineLabel(NO_PREVIEW_SEQ_AVAILABLE);
        this.currentPreviewLabel.setColumns(50);
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new BoxLayout(southPanel, 1));
        southPanel.setBorder(BorderFactory.createTitledBorder("Rename preview"));
        JPanel samplePanel = new JPanel(new FlowLayout());
        samplePanel.add(sampleLabel);
        samplePanel.add((Component)this.currentSampleLabel);
        JPanel previewPanel = new JPanel(new FlowLayout());
        previewPanel.add(previewLabel);
        previewPanel.add((Component)this.currentPreviewLabel);
        southPanel.add(samplePanel);
        southPanel.add(previewPanel);
        return southPanel;
    }

    @Override
    public boolean isValidConfiguration() {
        return this.getSelectedRenamePanel().isValidConfiguration();
    }

    @Override
    public HeaderRenamer getHeaderRenamer(HeaderTarget target) {
        return this.getSelectedRenamePanel().getHeaderRenamer(target);
    }

    private AbstractRenameHeaderPanel getSelectedRenamePanel() {
        return (AbstractRenameHeaderPanel)this.cardsPanel.getSelectedCard();
    }

    @Override
    public void onRenameConfigurationChanged(Object source) {
        this.updateCurrentPreview();
        this.fireRenameConfigurationChanged();
        this.updateTransformationProvider();
    }

    private void updateTransformationProvider() {
        if (this.isValidConfiguration()) {
            this.transformationProvider.setHeaderRenamer(this.getHeaderRenamer());
        } else {
            this.transformationProvider.clearHeaderRenamer();
        }
    }

    private HeaderTarget getHeaderTarget() {
        return (HeaderTarget)((Object)this.headerTargetRbtnPanel.getSelectedItem().get());
    }

    public HeaderRenamer getHeaderRenamer() {
        return this.getHeaderRenamer(this.getHeaderTarget());
    }

    private void sedaContextPathsChanged(SedaContextEvent event) {
        SwingUtilities.invokeLater(() -> {
            if (event.getType().equals((Object)SedaContextEvent.SedaContextEventType.SELECTED_PATHS_CHANGED)) {
                Iterator selectedPaths = this.sedaContext.getSelectedPaths().stream().sorted(PATH_SIZE_COMPARATOR).iterator();
                boolean set = false;
                while (selectedPaths.hasNext() && !set) {
                    String nextPreviewPath = (String)selectedPaths.next();
                    set = this.setPreviewPath(nextPreviewPath);
                }
                if (!set) {
                    this.clearPreviewPath();
                }
            }
        });
    }

    private void clearPreviewPath() {
        this.setPreviewSequence(null);
    }

    private boolean setPreviewPath(String path) {
        if (this.currentPath == null || !this.currentPath.equals(path)) {
            this.currentPath = path;
            try {
                SequencesGroup group = this.getDatatypeFactory().newSequencesGroup(new File(path).toPath());
                if (group.getSequenceCount() > 0) {
                    this.setPreviewSequence(group.getSequence(0));
                    return true;
                }
                this.currentPath = null;
                return false;
            }
            catch (OutOfMemoryError e) {
                StringBuilder message = new StringBuilder("Error processing dataset: ");
                message.append(e.getMessage()).append("<br/><br/>Please, visit the SEDA manual to know how to fix this issue: ").append("<a href=\"https://www.sing-group.org/seda/manual/installation-and-configuration.html#increasing-ram-memory\">").append("Installation and configuration / Increasing RAM memory</a>");
                JOptionPane.showMessageDialog(this, new HtmlMessage(message.toString()), "Transformation Error", 0);
                this.currentPath = null;
                return false;
            }
        }
        return true;
    }

    private void setPreviewSequence(Sequence sequence) {
        this.sampleSequence = sequence;
        if (this.sampleSequence != null) {
            this.currentSampleLabel.setText(sequence.getHeader());
        } else {
            this.currentPath = null;
            this.currentSampleLabel.setText(NO_PREVIEW_SEQ_AVAILABLE);
        }
        this.updateCurrentPreview();
    }

    private void updateCurrentPreview() {
        if (this.sampleSequence != null) {
            if (this.isValidConfiguration()) {
                Sequence previewSequence = this.getHeaderRenamer().rename(this.getDatatypeFactory().newSequencesGroup("Test", Collections.emptyMap(), this.sampleSequence), DatatypeFactory.getDefaultDatatypeFactory()).getSequence(0);
                this.currentPreviewLabel.setText(previewSequence.getHeader());
            } else {
                this.currentPreviewLabel.setText(INVALID_CONFIGURATION);
            }
        } else {
            this.currentPreviewLabel.setText(NO_PREVIEW_SEQ_AVAILABLE);
        }
    }

    private DatatypeFactory getDatatypeFactory() {
        return DatatypeFactory.newFactory(this.sedaContext.isInMemoryProcessingEnabled(), this.sedaContext.isCharsetSupport());
    }

    private void initTransformationProvider() {
        this.transformationProvider = new RenameHeaderTransformationProvider();
        this.updateTransformationProvider();
    }

    public RenameHeaderTransformationProvider getTransformationProvider() {
        return this.transformationProvider;
    }

    public void setSedaContext(SedaContext context) {
        this.sedaContext = context;
        this.sedaContext.addSedaContextListener(this::sedaContextPathsChanged);
    }

    public void setTransformationProvider(RenameHeaderTransformationProvider transformationProvider) {
        this.transformationProvider = transformationProvider;
        Rename selectedCard = null;
        HeaderRenamer renamer = this.transformationProvider.getHeaderRenamer();
        this.headerTargetRbtnPanel.setSelectedItem((Object)renamer.getHeaderTarget());
        if (renamer instanceof IntervalReplaceRenamer) {
            selectedCard = Rename.REPLACE_INTERVAL;
            ((IntervalReplaceRenamePanel)selectedCard.getPanel()).setHeaderRenamer((IntervalReplaceRenamer)renamer);
        } else if (renamer instanceof WordReplaceRenamer) {
            selectedCard = Rename.REPLACE_WORD;
            ((WordReplaceRenamePanel)selectedCard.getPanel()).setHeaderRenamer((WordReplaceRenamer)renamer);
        } else if (renamer instanceof AddStringHeaderRenamer) {
            selectedCard = Rename.ADD_STRING;
            ((AddStringHeaderRenamePanel)selectedCard.getPanel()).setHeaderRenamer((AddStringHeaderRenamer)renamer);
        } else if (renamer instanceof FieldSplitRenamer) {
            selectedCard = Rename.MULTIPART_HEADER;
            ((FieldSplitRenamePanel)selectedCard.getPanel()).setHeaderRenamer((FieldSplitRenamer)renamer);
        }
        this.cardsPanel.setSelectedCard((Object)selectedCard);
    }

    public static enum Rename {
        REPLACE_WORD("Replace word", new WordReplaceRenamePanel()),
        REPLACE_INTERVAL("Replace interval", new IntervalReplaceRenamePanel()),
        ADD_STRING("Add prefix/suffix", new AddStringHeaderRenamePanel()),
        MULTIPART_HEADER("Multipart header", new FieldSplitRenamePanel());

        private String name;
        private AbstractRenameHeaderPanel panel;

        private Rename(String name, AbstractRenameHeaderPanel panel) {
            this.name = name;
            this.panel = panel;
        }

        public String toString() {
            return this.name;
        }

        public AbstractRenameHeaderPanel getPanel() {
            return this.panel;
        }
    }
}

