/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui.configuration_panel.pattern;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.Optional;
import javax.swing.JPanel;
import org.sing_group.gc4s.input.RadioButtonsPanel;
import org.sing_group.gc4s.ui.CenteredJPanel;
import org.sing_group.seda.datatype.SequenceTarget;
import org.sing_group.seda.datatype.configuration.SequenceTranslationConfiguration;
import org.sing_group.seda.datatype.pattern.SequencePatternGroup;
import org.sing_group.seda.gui.configuration_panel.pattern.MultipleSequencePatternGroupPanel;
import org.sing_group.seda.gui.configuration_panel.translation.SequenceTranslationPanel;
import org.sing_group.seda.plugin.core.info.plugin.PatternFilteringSedaPluginInfo;

public class PatternFilteringConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String TRANSLATION_LABEL = "Convert to amino acid sequence before pattern matching";
    private static final String TRANSLATION_INFO = PatternFilteringSedaPluginInfo.PARAM_CONVERT_AMINO_ACID_HELP_GUI;
    private MultipleSequencePatternGroupPanel patternsPanel;
    private SequenceTranslationPanel translationPanel;
    private RadioButtonsPanel<SequenceTarget> sequenceTargetPanel;

    public PatternFilteringConfigurationPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getNorthPanel(), "North");
        this.add((Component)this.getPatternsPanel(), "Center");
    }

    private JPanel getNorthPanel() {
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.add((Component)this.getSequenceTargetPanel(), "West");
        northPanel.add(this.getTranslationPanelComponent(), "East");
        this.sequenceTargetPanel.setSelectedItem((Object)SequenceTarget.SEQUENCE);
        return northPanel;
    }

    public RadioButtonsPanel<SequenceTarget> getSequenceTargetPanel() {
        if (this.sequenceTargetPanel == null) {
            this.sequenceTargetPanel = new RadioButtonsPanel((Object[])SequenceTarget.values());
            this.sequenceTargetPanel.addItemListener(this::sequenceTargetChanged);
        }
        return this.sequenceTargetPanel;
    }

    private void sequenceTargetChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.translationPanel.setConversionEnabled(((SequenceTarget)((Object)this.sequenceTargetPanel.getSelectedItem().get())).isSequence());
        }
    }

    private Component getTranslationPanelComponent() {
        return new CenteredJPanel((Component)this.getTranslationPanel());
    }

    public SequenceTranslationPanel getTranslationPanel() {
        if (this.translationPanel == null) {
            this.translationPanel = new SequenceTranslationPanel(TRANSLATION_LABEL, TRANSLATION_INFO, true);
        }
        return this.translationPanel;
    }

    public MultipleSequencePatternGroupPanel getPatternsPanel() {
        if (this.patternsPanel == null) {
            this.patternsPanel = new MultipleSequencePatternGroupPanel();
        }
        return this.patternsPanel;
    }

    public void setTarget(SequenceTarget target) {
        if (target != null) {
            this.sequenceTargetPanel.setSelectedItem((Object)target);
        }
    }

    public void setTranslationConfiguration(SequenceTranslationConfiguration translationConfiguration) {
        this.translationPanel.setSequenceTranslationConfiguration(Optional.ofNullable(translationConfiguration));
    }

    public void setEvaluableSequencePattern(SequencePatternGroup pattern) {
        if (pattern != null) {
            this.patternsPanel.setSequencePatternGrup(pattern);
        }
    }
}

