/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui.configuration_panel.ncbi;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.io.File;
import java.util.LinkedList;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.swingx.JXTextField;
import org.sing_group.gc4s.event.DocumentAdapter;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.gc4s.input.filechooser.JFileChooserPanel;
import org.sing_group.gc4s.input.filechooser.JFileChooserPanelBuilder;
import org.sing_group.seda.gui.CommonFileChooser;
import org.sing_group.seda.plugin.core.info.plugin.NcbiRenameSedaPluginInfo;

public class ReplaceOptionsConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_REPLACEMENT_STRING = "seda.replaceoptionsconfiguration.replacementstring";
    public static final String PROPERTY_REPLACE_BLANK_SPACES = "seda.replaceoptionsconfiguration.replaceblankspaces";
    public static final String PROPERTY_REPLACE_SPECIAL_CHARACTERS = "seda.replaceoptionsconfiguration.replacespecialcharacters";
    public static final String PROPERTY_SAVE_REPLACEMENTS_MAP = "seda.replaceoptionsconfiguration.savereplacementsmap";
    public static final String PROPERTY_REPLACEMENTS_MAP_FILE = "seda.replaceoptionsconfiguration.replacementsmapfile";
    private static final String HELP_REPLACE_BLANK_SPACES = NcbiRenameSedaPluginInfo.PARAM_CONFIG_REPLACE_BLANK_SPACES_HELP_GUI;
    private static final String HELP_REPLACE_SPECIAL_CHARACTERS = NcbiRenameSedaPluginInfo.PARAM_CONFIG_REPLACE_SPECIAL_CHARACTERS_HELP_GUI;
    private static final String HELP_REPLACEMENT = NcbiRenameSedaPluginInfo.PARAM_CONFIG_REPLACEMENT_HELP_GUI;
    private static final String HELP_SAVE_REPLACEMENTS_MAP = NcbiRenameSedaPluginInfo.PARAM_CONFIG_SAVE_REPLACEMENTS_HELP_GUI;
    private static final String HELP_REPLACEMENTS_MAP_FILE = NcbiRenameSedaPluginInfo.PARAM_CONFIG_REPLACEMENTS_MAP_FILE_HELP_GUI;
    private JXTextField replacementStringTextField;
    private JCheckBox replaceBlankSpacesCheckbox;
    private JCheckBox replaceSpecialCharactersCheckbox;
    private JCheckBox saveReplacementsMapCheckbox;
    private JFileChooserPanel replacementsMapFileChooserPanel;

    public ReplaceOptionsConfigurationPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add(this.getParametersPanel(), "Center");
    }

    private Component getParametersPanel() {
        return new InputParametersPanel(this.getParameters());
    }

    private InputParameter[] getParameters() {
        LinkedList<InputParameter> parameters = new LinkedList<InputParameter>();
        parameters.add(this.getReplaceBlankSpacesParameter());
        parameters.add(this.getReplaceSpecialCharactersParameter());
        parameters.add(this.getReplacementStringParameter());
        parameters.add(this.getSaveReplacementsMapParameter());
        parameters.add(this.getReplacementsMapFileParameter());
        return parameters.toArray(new InputParameter[parameters.size()]);
    }

    private InputParameter getReplaceBlankSpacesParameter() {
        this.replaceBlankSpacesCheckbox = new JCheckBox();
        this.replaceBlankSpacesCheckbox.addItemListener(this::replaceBlankSpacesChanged);
        return new InputParameter("Replace blank spaces:", (JComponent)this.replaceBlankSpacesCheckbox, HELP_REPLACE_BLANK_SPACES);
    }

    private void replaceBlankSpacesChanged(ItemEvent event) {
        this.firePropertyChange(PROPERTY_REPLACE_BLANK_SPACES, null, (Object)this.isReplaceBlankSpaces());
    }

    public boolean isReplaceBlankSpaces() {
        return this.replaceBlankSpacesCheckbox.isSelected();
    }

    private InputParameter getReplaceSpecialCharactersParameter() {
        this.replaceSpecialCharactersCheckbox = new JCheckBox();
        this.replaceSpecialCharactersCheckbox.addItemListener(this::replaceSpecialCharactersChanged);
        return new InputParameter("Replace special characters:", (JComponent)this.replaceSpecialCharactersCheckbox, HELP_REPLACE_SPECIAL_CHARACTERS);
    }

    private void replaceSpecialCharactersChanged(ItemEvent event) {
        this.firePropertyChange(PROPERTY_REPLACE_SPECIAL_CHARACTERS, null, (Object)this.isReplaceSpecialCharacters());
    }

    public boolean isReplaceSpecialCharacters() {
        return this.replaceSpecialCharactersCheckbox.isSelected();
    }

    private InputParameter getReplacementStringParameter() {
        this.replacementStringTextField = new JXTextField("Replacement");
        this.replacementStringTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void removeUpdate(DocumentEvent e) {
                this.documentChanged();
            }

            public void insertUpdate(DocumentEvent e) {
                this.documentChanged();
            }

            private void documentChanged() {
                SwingUtilities.invokeLater(() -> ReplaceOptionsConfigurationPanel.this.replacementStringChanged());
            }
        });
        return new InputParameter("Replacement:", (JComponent)this.replacementStringTextField, HELP_REPLACEMENT);
    }

    private void replacementStringChanged() {
        this.firePropertyChange(PROPERTY_REPLACEMENT_STRING, null, this.getReplacementString());
    }

    public String getReplacementString() {
        return this.replacementStringTextField.getText();
    }

    private InputParameter getSaveReplacementsMapParameter() {
        this.saveReplacementsMapCheckbox = new JCheckBox();
        this.saveReplacementsMapCheckbox.addItemListener(this::saveReplacementsMapChanged);
        return new InputParameter("Save replacements map:", (JComponent)this.saveReplacementsMapCheckbox, HELP_SAVE_REPLACEMENTS_MAP);
    }

    private void saveReplacementsMapChanged(ItemEvent event) {
        this.firePropertyChange(PROPERTY_SAVE_REPLACEMENTS_MAP, null, (Object)this.isSaveReplacementsMap());
    }

    public boolean isSaveReplacementsMap() {
        return this.saveReplacementsMapCheckbox.isSelected();
    }

    private InputParameter getReplacementsMapFileParameter() {
        this.replacementsMapFileChooserPanel = JFileChooserPanelBuilder.createSaveJFileChooserPanel().withFileChooser(CommonFileChooser.getInstance().getFilechooser()).withLabel("").withClearSelectedFileOnShow(true).build();
        this.replacementsMapFileChooserPanel.addFileChooserListener(this::replacementsMapFileChanged);
        return new InputParameter("File:", (JComponent)this.replacementsMapFileChooserPanel, HELP_REPLACEMENTS_MAP_FILE);
    }

    private void replacementsMapFileChanged(ChangeEvent arg0) {
        this.firePropertyChange(PROPERTY_REPLACEMENTS_MAP_FILE, null, this.getReplacementsMapFile());
    }

    public File getReplacementsMapFile() {
        return this.replacementsMapFileChooserPanel.getSelectedFile();
    }

    public void setReplaceBlankSpaces(boolean newReplaceBlankSpaces) {
        this.replaceBlankSpacesCheckbox.setSelected(newReplaceBlankSpaces);
    }

    public void setReplaceSpecialCharacters(boolean replaceSpecialCharacters) {
        this.replaceSpecialCharactersCheckbox.setSelected(replaceSpecialCharacters);
    }

    public void setReplacementString(String newReplacementString) {
        this.replacementStringTextField.setText(newReplacementString);
    }

    public void setSaveReplacementsMap(boolean newSaveReplacementsMap) {
        this.saveReplacementsMapCheckbox.setSelected(newSaveReplacementsMap);
    }

    public void setReplacementsMapFile(File newReplacementsMapFile) {
        this.replacementsMapFileChooserPanel.setSelectedFile(newReplacementsMapFile);
    }
}

