/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.datatype;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.InDiskSequence;
import org.sing_group.seda.datatype.InDiskSequencesGroup;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.datatype.SequencesGroupDataset;
import org.sing_group.seda.io.IOUtils;

public class InDiskDatatypeFactory
implements DatatypeFactory {
    private final DatatypeFactory defaultFactory = DatatypeFactory.getDefaultDatatypeFactory();
    private final boolean charsetSupport;

    public InDiskDatatypeFactory() {
        this(false);
    }

    public InDiskDatatypeFactory(boolean charsetSupport) {
        this.charsetSupport = charsetSupport;
    }

    @Override
    public Sequence newSequence(String name, String description, String sequence, Map<String, Object> properties) {
        return new InDiskSequence(name, description, sequence, properties);
    }

    @Override
    public SequencesGroup newSequencesGroup(Path file) {
        try {
            Charset charset = this.charsetSupport ? IOUtils.detectCharset(file) : null;
            return new InDiskSequencesGroup(file, charset);
        }
        catch (IOException e) {
            throw new RuntimeException("Error detecting charset", e);
        }
    }

    @Override
    public SequencesGroup newSequencesGroup(String name, Map<String, Object> properties, Sequence ... sequences) {
        return new InDiskSequencesGroup(name, properties, sequences);
    }

    @Override
    public SequencesGroup newSequencesGroup(String name, Map<String, Object> properties, List<Sequence> sequences) {
        return this.newSequencesGroup(name, properties, sequences.toArray(new Sequence[sequences.size()]));
    }

    @Override
    public SequencesGroupDataset newSequencesGroupDataset(SequencesGroup ... sequencesGroups) {
        return this.defaultFactory.newSequencesGroupDataset(sequencesGroups);
    }
}

