/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.core.split;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.sing_group.seda.core.split.AbstractSequencesGroupSplitter;
import org.sing_group.seda.core.split.DefaultSequencesSort;
import org.sing_group.seda.core.split.SequencesSort;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequencesGroup;

public class NumberOfSequencesAndNumberOfFilesWithIndependentExtractionsSplitter
extends AbstractSequencesGroupSplitter {
    private int numFiles;
    private int numSequences;

    public NumberOfSequencesAndNumberOfFilesWithIndependentExtractionsSplitter(int numFiles, int numSequences) {
        this(numFiles, numSequences, new DefaultSequencesSort(), DatatypeFactory.getDefaultDatatypeFactory());
    }

    public NumberOfSequencesAndNumberOfFilesWithIndependentExtractionsSplitter(int numFiles, int numSequences, SequencesSort sequencesSort, DatatypeFactory factory) {
        super(sequencesSort, factory);
        this.numFiles = numFiles;
        this.numSequences = numSequences;
    }

    @Override
    public List<SequencesGroup> split(SequencesGroup group) {
        LinkedList<SequencesGroup> toret = new LinkedList<SequencesGroup>();
        for (int file = 0; file < this.numFiles; ++file) {
            List<Sequence> input = this.getInputSequencesGroup(group);
            Iterator<Sequence> inputIterator = input.iterator();
            LinkedList<Sequence> currentSubList = new LinkedList<Sequence>();
            for (int i = 0; i < this.numSequences; ++i) {
                if (!inputIterator.hasNext()) {
                    inputIterator = input.iterator();
                }
                currentSubList.add(inputIterator.next());
            }
            toret.add(this.createGroup(group.getName() + "_" + (file + 1), group.getProperties(), currentSubList));
        }
        return toret;
    }
}

