/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.core.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.sing_group.seda.core.rename.HeaderTarget;
import org.sing_group.seda.core.rename.WordReplaceRenamer;
import org.sing_group.seda.plugin.spi.DefaultValidation;
import org.sing_group.seda.plugin.spi.Validation;

@XmlRootElement
public class IntervalReplaceRenamer
extends WordReplaceRenamer {
    @XmlElement
    private String from;
    @XmlElement
    private String to;

    public IntervalReplaceRenamer() {
    }

    public IntervalReplaceRenamer(HeaderTarget target, String from, String to, String replacement) {
        super(target, replacement, true, Arrays.asList(new String(Pattern.quote(from) + ".*" + Pattern.quote(to))));
        this.from = from;
        this.to = to;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    @Override
    public Validation validate() {
        ArrayList<String> errors = new ArrayList<String>(super.validate().getValidationErrors());
        if (this.from == null) {
            errors.add("The from string can't be null.");
        }
        if (this.to == null) {
            errors.add("The to string can't be null.");
        }
        return new DefaultValidation(errors);
    }
}

