/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.cli.command;

import es.uvigo.ei.sing.yacli.command.option.FileOption;
import es.uvigo.ei.sing.yacli.command.option.FlagOption;
import es.uvigo.ei.sing.yacli.command.option.Option;
import es.uvigo.ei.sing.yacli.command.parameter.Parameters;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.sing_group.seda.cli.SedaCommand;
import org.sing_group.seda.cli.parameters.SequenceTranslationCliParameters;
import org.sing_group.seda.core.io.JsonObjectReader;
import org.sing_group.seda.datatype.configuration.SequenceTranslationConfiguration;
import org.sing_group.seda.plugin.core.info.plugin.RemoveRedundantSequencesSedaPluginInfo;
import org.sing_group.seda.plugin.spi.TransformationProvider;
import org.sing_group.seda.transformation.provider.redundant.RemoveRedundantSequencesTransformationProvider;
import org.sing_group.seda.transformation.sequencesgroup.RemoveRedundantSequencesTransformation;

public class RemoveRedundantSequencesCommand
extends SedaCommand {
    public static final FlagOption OPTION_REMOVE_SUBSEQUENCE = new FlagOption("remove-subsequences", "rs", "Remove also sequences contained within larger sequences.");
    public static final FlagOption OPTION_MERGE_HEADERS = new FlagOption("merge-headers", "mh", "Use this option to specify that headers of new sequences must be created by concatenating the headers of the two sequences being merged. By default, if not specified, the headers of the new sequences are the header of one of the two being merged.");
    public static final FileOption OPTION_SAVE_MERGED_HEADERS = new FileOption("save-merged-headers", "smh", "Whether report files of the merged headers must be created or not. If you do not want to save them, leave this file empty. Otherwise, choose the directory where such files should be created.", true, true);
    private SequenceTranslationCliParameters sequenceTranslationCliParameters;

    public String getName() {
        return "remove-redundant";
    }

    public String getDescriptiveName() {
        return "Remove redundant sequences";
    }

    public String getDescription() {
        return "If several identical sequences (or subsequences, if chosen) are found, keep only one (user may choose to merge headers).";
    }

    @Override
    protected String getSedaGroup() {
        return RemoveRedundantSequencesSedaPluginInfo.GROUP;
    }

    @Override
    protected List<Option<?>> createSedaOptions() {
        this.sequenceTranslationCliParameters = new SequenceTranslationCliParameters(true, false, "If this option is selected, then input nucleic acid sequences are translated into amino acid sequences before applying the sequence comparison. In this case, note that the input nucleic acid sequences are reported.");
        ArrayList options = new ArrayList();
        options.add((Option<?>)OPTION_REMOVE_SUBSEQUENCE);
        options.add((Option<?>)OPTION_MERGE_HEADERS);
        options.add((Option<?>)OPTION_SAVE_MERGED_HEADERS);
        options.addAll(this.sequenceTranslationCliParameters.getOptionList());
        return options;
    }

    @Override
    protected TransformationProvider getTransformation(Parameters parameters) {
        RemoveRedundantSequencesTransformationProvider provider = new RemoveRedundantSequencesTransformationProvider();
        boolean mergeHeaders = parameters.hasFlag((Option)OPTION_MERGE_HEADERS);
        File mergedHeadersFile = null;
        if (parameters.hasOption((Option)OPTION_SAVE_MERGED_HEADERS)) {
            mergedHeadersFile = (File)parameters.getSingleValue((Option)OPTION_SAVE_MERGED_HEADERS);
            if (!mergedHeadersFile.isDirectory()) {
                RemoveRedundantSequencesCommand.formattedValidationError(RemoveRedundantSequencesCommand.formatParam(OPTION_SAVE_MERGED_HEADERS) + " option must be a directory");
            }
            provider.setConfiguration(new RemoveRedundantSequencesTransformation.RemoveRedundantSequencesTransformationConfiguration(this.getRemoveRedundantMode(parameters), mergeHeaders, mergedHeadersFile, this.getTranslationConfiguration(parameters)));
        } else {
            provider.setConfiguration(new RemoveRedundantSequencesTransformation.RemoveRedundantSequencesTransformationConfiguration(this.getRemoveRedundantMode(parameters), mergeHeaders, this.getTranslationConfiguration(parameters)));
        }
        return provider;
    }

    private SequenceTranslationConfiguration getTranslationConfiguration(Parameters parameters) {
        SequenceTranslationConfiguration translationConfiguration = null;
        if (this.sequenceTranslationCliParameters.hasConvertAminoAcid(parameters)) {
            try {
                translationConfiguration = this.sequenceTranslationCliParameters.getSequenceTranslationConfiguration(parameters);
            }
            catch (IllegalArgumentException e) {
                RemoveRedundantSequencesCommand.formattedValidationError(e.getMessage());
            }
        }
        return translationConfiguration;
    }

    private RemoveRedundantSequencesTransformation.Mode getRemoveRedundantMode(Parameters parameters) {
        if (parameters.hasFlag((Option)OPTION_REMOVE_SUBSEQUENCE)) {
            return RemoveRedundantSequencesTransformation.Mode.CONTAINED_SEQUENCES;
        }
        return RemoveRedundantSequencesTransformation.Mode.EXACT_DUPLICATES;
    }

    @Override
    protected TransformationProvider getTransformation(File parametersFile) throws IOException {
        return (TransformationProvider)new JsonObjectReader().read(parametersFile, RemoveRedundantSequencesTransformationProvider.class);
    }
}

