/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.bio;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sing_group.seda.datatype.InMemorySequence;
import org.sing_group.seda.datatype.Sequence;

public final class SequenceUtils {
    public static final String STOP_CODON = "*";
    public static final String NON_CODON = "1";
    public static final Map<String, String> STANDARD_CODON_TABLE;

    private SequenceUtils() {
    }

    public static Stream<String> toCodons(Sequence sequence) {
        return SequenceUtils.toCodons(sequence.getChain(), false, false);
    }

    public static Stream<String> toCodons(Sequence sequence, boolean ignoreExtraNucleotides) {
        return SequenceUtils.toCodons(sequence.getChain(), ignoreExtraNucleotides, true);
    }

    public static Stream<String> toCodons(Sequence sequence, boolean ignoreExtraNucleotides, boolean checkGeneSequence) {
        return SequenceUtils.toCodons(sequence.getChain(), ignoreExtraNucleotides, checkGeneSequence);
    }

    public static Stream<String> toCodons(String chain) {
        return SequenceUtils.toCodons(chain, false, false);
    }

    public static Stream<String> toCodons(String chain, boolean ignoreExtraNucleotides) {
        return SequenceUtils.toCodons(chain, ignoreExtraNucleotides, true);
    }

    public static Stream<String> toCodons(String chain, boolean ignoreExtraNucleotides, boolean checkGeneSequence) {
        if (chain.length() % 3 != 0 && !ignoreExtraNucleotides) {
            throw new IllegalArgumentException("Sequence length must be multiple of 3");
        }
        if (checkGeneSequence && !SequenceUtils.isGene(chain)) {
            throw new IllegalArgumentException("Only gene sequences are allowed");
        }
        int numCodons = chain.length() / 3;
        String[] codons = new String[numCodons];
        for (int i = 0; i < numCodons; ++i) {
            codons[i] = chain.substring(i * 3, (i + 1) * 3);
        }
        return Arrays.stream(codons);
    }

    public static boolean isGene(Sequence sequence) {
        return SequenceUtils.isGene(sequence.getChain());
    }

    public static boolean isGene(String chain) {
        return chain.toUpperCase().replaceAll("[ACGTU-]", "").isEmpty();
    }

    public static String translate(String chain, boolean reverseComplement, Map<String, String> codonTable) {
        return SequenceUtils.translate(chain, reverseComplement, 1, codonTable);
    }

    public static String translate(String chain, boolean reverseComplement, int frame, Map<String, String> codonTable) {
        if (frame < 1 || frame > 3) {
            throw new IllegalArgumentException("Starting frame must be 1, 2 or 3");
        }
        chain = chain.toUpperCase();
        if (reverseComplement) {
            chain = SequenceUtils.reverseComplement(chain);
        }
        String effectiveChain = chain.substring(frame - 1);
        Stream<String> codons = SequenceUtils.toCodons(effectiveChain, true);
        return codons.map(c -> codonTable.getOrDefault(c, NON_CODON)).collect(Collectors.joining());
    }

    public static List<Sequence> reverseComplement(List<Sequence> sequences) {
        return SequenceUtils.reverseComplement(sequences.stream());
    }

    public static List<Sequence> reverseComplement(Stream<Sequence> sequences) {
        return sequences.map(SequenceUtils::reverseComplement).collect(Collectors.toList());
    }

    public static Sequence reverseComplement(Sequence sequence) {
        return new InMemorySequence(sequence.getName(), sequence.getDescription(), SequenceUtils.reverseComplement(sequence.getChain()), sequence.getProperties());
    }

    public static String reverse(String chain) {
        return new StringBuilder(chain).reverse().toString();
    }

    public static String reverseComplement(String chain) {
        return SequenceUtils.reverse(SequenceUtils.complement(chain));
    }

    public static String complement(String chain) {
        StringBuilder reversed = new StringBuilder();
        block34: for (int i = 0; i < chain.length(); ++i) {
            switch (chain.charAt(i)) {
                case 'A': {
                    reversed.append("T");
                    continue block34;
                }
                case 'a': {
                    reversed.append("t");
                    continue block34;
                }
                case 'T': {
                    reversed.append("A");
                    continue block34;
                }
                case 't': {
                    reversed.append("a");
                    continue block34;
                }
                case 'U': {
                    reversed.append("A");
                    continue block34;
                }
                case 'u': {
                    reversed.append("a");
                    continue block34;
                }
                case 'C': {
                    reversed.append("G");
                    continue block34;
                }
                case 'c': {
                    reversed.append("g");
                    continue block34;
                }
                case 'G': {
                    reversed.append("C");
                    continue block34;
                }
                case 'g': {
                    reversed.append("c");
                    continue block34;
                }
                case 'Y': {
                    reversed.append("R");
                    continue block34;
                }
                case 'y': {
                    reversed.append("r");
                    continue block34;
                }
                case 'R': {
                    reversed.append("Y");
                    continue block34;
                }
                case 'r': {
                    reversed.append("y");
                    continue block34;
                }
                case 'S': {
                    reversed.append("S");
                    continue block34;
                }
                case 's': {
                    reversed.append("s");
                    continue block34;
                }
                case 'W': {
                    reversed.append("W");
                    continue block34;
                }
                case 'w': {
                    reversed.append("w");
                    continue block34;
                }
                case 'K': {
                    reversed.append("M");
                    continue block34;
                }
                case 'k': {
                    reversed.append("m");
                    continue block34;
                }
                case 'M': {
                    reversed.append("K");
                    continue block34;
                }
                case 'm': {
                    reversed.append("k");
                    continue block34;
                }
                case 'B': {
                    reversed.append("V");
                    continue block34;
                }
                case 'b': {
                    reversed.append("v");
                    continue block34;
                }
                case 'D': {
                    reversed.append("H");
                    continue block34;
                }
                case 'd': {
                    reversed.append("h");
                    continue block34;
                }
                case 'H': {
                    reversed.append("D");
                    continue block34;
                }
                case 'h': {
                    reversed.append("d");
                    continue block34;
                }
                case 'V': {
                    reversed.append("B");
                    continue block34;
                }
                case 'v': {
                    reversed.append("b");
                    continue block34;
                }
                case 'N': {
                    reversed.append("N");
                    continue block34;
                }
                case 'n': {
                    reversed.append("n");
                    continue block34;
                }
                default: {
                    reversed.append(chain.charAt(i));
                }
            }
        }
        return reversed.toString();
    }

    public static Map<Character, Integer> countBases(String s) {
        HashMap<Character, Integer> toret = new HashMap<Character, Integer>();
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            toret.putIfAbsent(c, 0);
            toret.put(c, (Integer)toret.get(c) + 1);
        }
        return toret;
    }

    static {
        HashMap<String, String> standardCodonTable = new HashMap<String, String>();
        standardCodonTable.put("---", "-");
        standardCodonTable.put("TTT", "F");
        standardCodonTable.put("TTC", "F");
        standardCodonTable.put("TTA", "L");
        standardCodonTable.put("TTG", "L");
        standardCodonTable.put("CTT", "L");
        standardCodonTable.put("CTC", "L");
        standardCodonTable.put("CTA", "L");
        standardCodonTable.put("CTG", "L");
        standardCodonTable.put("ATT", "I");
        standardCodonTable.put("ATC", "I");
        standardCodonTable.put("ATA", "I");
        standardCodonTable.put("ATG", "M");
        standardCodonTable.put("GTT", "V");
        standardCodonTable.put("GTC", "V");
        standardCodonTable.put("GTA", "V");
        standardCodonTable.put("GTG", "V");
        standardCodonTable.put("TCT", "S");
        standardCodonTable.put("TCC", "S");
        standardCodonTable.put("TCA", "S");
        standardCodonTable.put("TCG", "S");
        standardCodonTable.put("CCT", "P");
        standardCodonTable.put("CCC", "P");
        standardCodonTable.put("CCA", "P");
        standardCodonTable.put("CCG", "P");
        standardCodonTable.put("ACT", "T");
        standardCodonTable.put("ACC", "T");
        standardCodonTable.put("ACA", "T");
        standardCodonTable.put("ACG", "T");
        standardCodonTable.put("GCT", "A");
        standardCodonTable.put("GCC", "A");
        standardCodonTable.put("GCA", "A");
        standardCodonTable.put("GCG", "A");
        standardCodonTable.put("TAT", "Y");
        standardCodonTable.put("TAC", "Y");
        standardCodonTable.put("TAA", STOP_CODON);
        standardCodonTable.put("TAG", STOP_CODON);
        standardCodonTable.put("CAT", "H");
        standardCodonTable.put("CAC", "H");
        standardCodonTable.put("CAA", "Q");
        standardCodonTable.put("CAG", "Q");
        standardCodonTable.put("AAT", "N");
        standardCodonTable.put("AAC", "N");
        standardCodonTable.put("AAA", "K");
        standardCodonTable.put("AAG", "K");
        standardCodonTable.put("GAT", "D");
        standardCodonTable.put("GAC", "D");
        standardCodonTable.put("GAA", "E");
        standardCodonTable.put("GAG", "E");
        standardCodonTable.put("TGT", "C");
        standardCodonTable.put("TGC", "C");
        standardCodonTable.put("TGA", STOP_CODON);
        standardCodonTable.put("TGG", "W");
        standardCodonTable.put("CGT", "R");
        standardCodonTable.put("CGC", "R");
        standardCodonTable.put("CGA", "R");
        standardCodonTable.put("CGG", "R");
        standardCodonTable.put("AGT", "S");
        standardCodonTable.put("AGC", "S");
        standardCodonTable.put("AGA", "R");
        standardCodonTable.put("AGG", "R");
        standardCodonTable.put("GGT", "G");
        standardCodonTable.put("GGC", "G");
        standardCodonTable.put("GGA", "G");
        standardCodonTable.put("GGG", "G");
        STANDARD_CODON_TABLE = Collections.unmodifiableMap(standardCodonTable);
    }
}

