/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.visualization.table;

import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.table.AbstractTableModel;

public class BeanTableModel<T>
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private List<T> beans;
    private Map<T, Map<String, Object>> propertiesMap;
    private LinkedList<String> columns;

    public BeanTableModel(List<T> beans) {
        this.beans = beans;
        this.initData();
    }

    protected void initData() {
        this.propertiesMap = this.beans.stream().collect(Collectors.toMap(o -> o, o -> BeanTableModel.beanProperties(o)));
        this.columns = new LinkedList<String>(this.propertiesMap.get(this.beans.get(0)).keySet());
    }

    @Override
    public int getRowCount() {
        return this.beans.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columns.get(columnIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.getValueAt(0, columnIndex).getClass();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.propertiesMap.get(this.beans.get(rowIndex)).get(this.columns.get(columnIndex));
    }

    protected static Map<String, Object> beanProperties(Object bean) {
        try {
            return BeanTableModel.getPropertyDescriptors(bean).stream().filter(pd -> Objects.nonNull(pd.getReadMethod())).collect(Collectors.toMap(FeatureDescriptor::getName, pd -> {
                try {
                    return pd.getReadMethod().invoke(bean, new Object[0]);
                }
                catch (Exception e) {
                    return null;
                }
            }));
        }
        catch (IntrospectionException e) {
            return Collections.emptyMap();
        }
    }

    protected static Collection<PropertyDescriptor> getPropertyDescriptors(Object bean) throws IntrospectionException {
        return Arrays.asList(Introspector.getBeanInfo(bean.getClass(), Object.class).getPropertyDescriptors());
    }
}

