/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.prosplign.transformation.dataset;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.sing_group.seda.blast.execution.BlastBinariesExecutor;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.datatype.SequencesGroupDataset;
import org.sing_group.seda.io.FastaWriter;
import org.sing_group.seda.prosplign.execution.ProSplignCompartBinariesExecutor;
import org.sing_group.seda.prosplign.execution.ProSplignCompartPipeline;
import org.sing_group.seda.transformation.TransformationException;
import org.sing_group.seda.transformation.dataset.SequencesGroupDatasetTransformation;

public class ProSplignCompartPipelineSequencesGroupDatasetTransformation
implements SequencesGroupDatasetTransformation {
    public static final int DEFAULT_MAX_TARGET_SEQS = 1;
    private int maxTargetSeqs;
    private File nucleotideFasta;
    private final DatatypeFactory factory;
    private BlastBinariesExecutor blastBinariesExecutor;
    private ProSplignCompartBinariesExecutor proSplignCompartBinariesExecutor;

    public ProSplignCompartPipelineSequencesGroupDatasetTransformation(ProSplignCompartBinariesExecutor proSplignCompartBinariesExecutor, BlastBinariesExecutor blastBinariesExecutor, File nucleotideFasta, int maxTargetSeqs) {
        this(DatatypeFactory.getDefaultDatatypeFactory(), proSplignCompartBinariesExecutor, blastBinariesExecutor, nucleotideFasta, maxTargetSeqs);
    }

    public ProSplignCompartPipelineSequencesGroupDatasetTransformation(DatatypeFactory factory, ProSplignCompartBinariesExecutor proSplignCompartBinariesExecutor, BlastBinariesExecutor blastBinariesExecutor, File nucleotideFasta, int maxTargetSeqs) {
        this.proSplignCompartBinariesExecutor = proSplignCompartBinariesExecutor;
        this.blastBinariesExecutor = blastBinariesExecutor;
        this.factory = factory;
        this.nucleotideFasta = nucleotideFasta;
        this.maxTargetSeqs = maxTargetSeqs;
    }

    @Override
    public SequencesGroupDataset transform(SequencesGroupDataset sequencesGroupDataset) throws TransformationException {
        try {
            return this.runPipeline(sequencesGroupDataset, this.factory);
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new TransformationException("Error while running ProSplign/ProCompart. " + e.getMessage());
        }
    }

    private SequencesGroupDataset runPipeline(SequencesGroupDataset sequencesGroupDataset, DatatypeFactory factory) throws IOException, InterruptedException, ExecutionException {
        ProSplignCompartPipeline pipeline = new ProSplignCompartPipeline(this.proSplignCompartBinariesExecutor, this.blastBinariesExecutor, this.nucleotideFasta);
        LinkedList<SequencesGroup> results = new LinkedList<SequencesGroup>();
        try {
            for (SequencesGroup sequencesGroup : sequencesGroupDataset.getSequencesGroups().collect(Collectors.toList())) {
                Path nucleotideSubjectFasta = Files.createTempFile(sequencesGroup.getName(), "fasta", new FileAttribute[0]);
                FastaWriter.writeFasta(nucleotideSubjectFasta, sequencesGroup.getSequences());
                Path outputFasta = Files.createTempFile(sequencesGroup.getName() + "_prosplign_procompart", ".fasta", new FileAttribute[0]);
                pipeline.proSplignCompart(nucleotideSubjectFasta.toFile(), outputFasta.toFile(), this.maxTargetSeqs);
                List<Sequence> alignedSequences = factory.newSequencesGroup(outputFasta).getSequences().collect(Collectors.toList());
                results.add(factory.newSequencesGroup(sequencesGroup.getName(), sequencesGroup.getProperties(), alignedSequences));
            }
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (ExecutionException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (!Boolean.valueOf(System.getProperty("seda.prospligncompart.keeptemporaryfiles", "false")).booleanValue()) {
                pipeline.clearTemporaryFiles();
            }
        }
        return factory.newSequencesGroupDataset(results.toArray(new SequencesGroup[results.size()]));
    }
}

