/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.prosplign.execution;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProSplignTxtParser {
    private int sequencesCount = 1;
    private List<String> sequences;
    private List<String> resultsSequences;
    private Set<String> resultsSequencesHeaderSet;
    private Map<String, String> outputHeaders;

    public void parse(Path testFile) throws IOException {
        this.parse(testFile, Collections.emptyMap(), Collections.emptyMap());
    }

    public void parse(Path proSplignTxtOutputFile, Map<String, String> queryHeaderMapping, Map<String, String> subjectHeaderMapping) throws IOException {
        this.parseSequences(proSplignTxtOutputFile, queryHeaderMapping, subjectHeaderMapping);
    }

    public List<String> getSequences() {
        return this.sequences;
    }

    public List<String> getFullSequences() {
        return this.resultsSequences;
    }

    private void parseSequences(Path testFile, Map<String, String> queryHeaderMapping, Map<String, String> subjectHeaderMapping) throws IOException {
        this.sequences = new LinkedList<String>();
        this.resultsSequences = new LinkedList<String>();
        this.resultsSequencesHeaderSet = new HashSet<String>();
        this.outputHeaders = new HashMap<String, String>();
        int asteriskCount = 0;
        Iterator<String> lines = Files.readAllLines(testFile).iterator();
        while (lines.hasNext()) {
            String line = lines.next();
            if (!line.startsWith("*") || ++asteriskCount != 3) continue;
            this.sequences.addAll(this.processSequenceBlock(lines, queryHeaderMapping, subjectHeaderMapping));
            asteriskCount = 0;
        }
    }

    private List<String> processSequenceBlock(Iterator<String> lines, Map<String, String> queryHeaderMapping, Map<String, String> subjectHeaderMapping) {
        if (lines.hasNext()) {
            String outputFullSequenceHeader;
            LinkedList<String> toretBlockSequences = new LinkedList<String>();
            String header = lines.next();
            String[] headerFields = header.split("\t");
            String fullSequenceHeader = headerFields[1] + " " + headerFields[3] + " " + headerFields[4];
            List<String> blockSequences = ProSplignTxtParser.extractBlockSequences(lines);
            String currentResultSequence = blockSequences.remove(blockSequences.size() - 1);
            if (!this.resultsSequencesHeaderSet.contains(fullSequenceHeader)) {
                this.resultsSequencesHeaderSet.add(fullSequenceHeader);
                outputFullSequenceHeader = subjectHeaderMapping.getOrDefault(headerFields[1], headerFields[1]) + " (from " + fullSequenceHeader.substring(fullSequenceHeader.indexOf(" ") + 1) + ")";
                this.resultsSequences.add(">" + outputFullSequenceHeader);
                this.resultsSequences.add(currentResultSequence);
                this.outputHeaders.put(fullSequenceHeader, outputFullSequenceHeader);
            }
            outputFullSequenceHeader = this.outputHeaders.get(fullSequenceHeader);
            for (String s : blockSequences) {
                if (s.isEmpty()) continue;
                toretBlockSequences.add(">" + this.sequencesCount++ + " " + outputFullSequenceHeader + " annotated with " + queryHeaderMapping.getOrDefault(headerFields[2], headerFields[2]));
                toretBlockSequences.add(s);
            }
            return toretBlockSequences;
        }
        throw new RuntimeException("Invalid sequence part.");
    }

    private static List<String> extractBlockSequences(Iterator<String> lines) {
        String firstLine;
        LinkedList<String> blockSequences = new LinkedList<String>();
        StringBuilder currentSequence = new StringBuilder();
        StringBuilder fullSequence = new StringBuilder();
        while (lines.hasNext() && !(firstLine = lines.next()).isEmpty()) {
            int i;
            LinkedList<String> block = new LinkedList<String>();
            block.add(firstLine);
            for (i = 0; i < 4; ++i) {
                if (!lines.hasNext()) continue;
                block.add(lines.next());
            }
            if (block.size() == 5) {
                for (i = 0; i < ((String)block.get(4)).length(); ++i) {
                    if (ProSplignTxtParser.isNucleotide(((String)block.get(0)).toUpperCase().charAt(i))) {
                        fullSequence.append(((String)block.get(0)).charAt(i));
                    }
                    if (((String)block.get(4)).charAt(i) == '*') {
                        if (((String)block.get(3)).charAt(i) == '.' || ((String)block.get(0)).charAt(i) == '-') continue;
                        currentSequence.append(((String)block.get(0)).charAt(i));
                        continue;
                    }
                    if (currentSequence.toString().isEmpty() || currentSequence.toString().endsWith("|") || !ProSplignTxtParser.isNucleotide(((String)block.get(0)).toUpperCase().charAt(i))) continue;
                    blockSequences.add(currentSequence.toString());
                    currentSequence = new StringBuilder();
                }
                continue;
            }
            throw new RuntimeException("Invalid sequence block.");
        }
        blockSequences.add(currentSequence.toString());
        blockSequences.add(fullSequence.toString());
        return blockSequences;
    }

    private static boolean isNucleotide(char charAt) {
        return charAt == 'A' || charAt == 'C' || charAt == 'T' || charAt == 'G' || charAt == 'Y' || charAt == 'R' || charAt == 'W' || charAt == 'S' || charAt == 'K' || charAt == 'M' || charAt == 'D' || charAt == 'V' || charAt == 'H' || charAt == 'B' || charAt == 'X' || charAt == 'N';
    }
}

