/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.cga.transformation.provider;

import java.io.File;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.sing_group.seda.cga.execution.CgaBinariesExecutor;
import org.sing_group.seda.cga.execution.CgaCompiPipelineConfiguration;
import org.sing_group.seda.cga.transformation.dataset.CgaPipelineSequencesGroupDatasetTransformation;
import org.sing_group.seda.cga.transformation.dataset.CgaResults;
import org.sing_group.seda.cga.transformation.provider.CgaPipelineTransformationConfigurationChangeType;
import org.sing_group.seda.core.execution.BinaryCheckException;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.plugin.spi.AbstractTransformationProvider;
import org.sing_group.seda.plugin.spi.DefaultValidation;
import org.sing_group.seda.plugin.spi.Validation;
import org.sing_group.seda.transformation.dataset.SequencesGroupDatasetTransformation;

@XmlRootElement
public class CgaPipelineTransformationProvider
extends AbstractTransformationProvider {
    @XmlAnyElement(lax=true)
    private CgaBinariesExecutor cgaBinariesExecutor;
    @XmlElement
    private File referenceFasta;
    @XmlElement
    private CgaCompiPipelineConfiguration cgaCompiPipelineConfiguration;
    @XmlElement
    private CgaResults cgaResults;
    @XmlElement
    private int compiTasks;

    @Override
    public Validation validate() {
        if (this.cgaBinariesExecutor == null) {
            return new DefaultValidation("The CGA pipeline executor has not been set.");
        }
        try {
            this.cgaBinariesExecutor.checkBinary();
        }
        catch (BinaryCheckException e) {
            return new DefaultValidation("The CGA pipeline executor can't be used.");
        }
        if (this.referenceFasta == null) {
            return new DefaultValidation("The reference FASTA file is mandatory.");
        }
        if (this.cgaCompiPipelineConfiguration == null) {
            return new DefaultValidation("The CGA pipeline configuration is mandatory.");
        }
        if (this.cgaResults == null) {
            return new DefaultValidation("The CGA results value is mandatory.");
        }
        return new DefaultValidation(new String[0]);
    }

    @Override
    public SequencesGroupDatasetTransformation getTransformation(DatatypeFactory factory) {
        return new CgaPipelineSequencesGroupDatasetTransformation(factory, this.cgaCompiPipelineConfiguration, this.referenceFasta, this.cgaResults, this.getAdditionalCompiParameters(), this.cgaBinariesExecutor);
    }

    private String getAdditionalCompiParameters() {
        return String.join((CharSequence)" ", "-n", Integer.toString(this.compiTasks));
    }

    public void setCgaBinariesExecutor(Optional<CgaBinariesExecutor> cgaBinariesExecutor) {
        this.cgaBinariesExecutor = cgaBinariesExecutor.orElse(null);
        this.fireTransformationsConfigurationModelEvent(CgaPipelineTransformationConfigurationChangeType.CGA_EXECUTOR_CHANGED, this.cgaBinariesExecutor);
    }

    public CgaBinariesExecutor getcgaBinariesExecutor() {
        return this.cgaBinariesExecutor;
    }

    public void setReferenceFasta(File referenceFasta) {
        if (this.referenceFasta == null || !this.referenceFasta.equals(referenceFasta)) {
            this.referenceFasta = referenceFasta;
            this.fireTransformationsConfigurationModelEvent(CgaPipelineTransformationConfigurationChangeType.REFERENCE_FASTA_CHANGED, this.referenceFasta);
        }
    }

    public void clearQueryFile() {
        if (this.referenceFasta != null) {
            this.referenceFasta = null;
            this.fireTransformationsConfigurationModelEvent(CgaPipelineTransformationConfigurationChangeType.REFERENCE_FASTA_CHANGED, this.referenceFasta);
        }
    }

    public File getreferenceFasta() {
        return this.referenceFasta;
    }

    public void setCgaResults(CgaResults cgaResults) {
        if (this.cgaResults == null || !this.cgaResults.equals((Object)cgaResults)) {
            this.cgaResults = cgaResults;
            this.fireTransformationsConfigurationModelEvent(CgaPipelineTransformationConfigurationChangeType.CGA_RESULTS_CHANGED, (Object)this.cgaResults);
        }
    }

    public CgaResults getCgaResults() {
        return this.cgaResults;
    }

    public void setCgaCompiPipelineConfiguration(CgaCompiPipelineConfiguration cgaCompiPipelineConfiguration) {
        if (this.cgaCompiPipelineConfiguration == null || !this.cgaCompiPipelineConfiguration.equals(cgaCompiPipelineConfiguration)) {
            this.cgaCompiPipelineConfiguration = cgaCompiPipelineConfiguration;
            this.fireTransformationsConfigurationModelEvent(CgaPipelineTransformationConfigurationChangeType.CGA_PIPELINE_CONFIGURATION_CHANGED, this.cgaCompiPipelineConfiguration);
        }
    }

    public CgaCompiPipelineConfiguration getCgaCompiPipelineConfiguration() {
        return this.cgaCompiPipelineConfiguration;
    }

    public void setCompiTasks(int compiTasks) {
        if (this.compiTasks != compiTasks) {
            this.compiTasks = compiTasks;
            this.fireTransformationsConfigurationModelEvent(CgaPipelineTransformationConfigurationChangeType.CGA_COMPI_TASKS, this.compiTasks);
        }
    }

    public int getCompiTasks() {
        return this.compiTasks;
    }
}

