/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.cga.transformation.dataset;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.sing_group.seda.cga.execution.CgaBinariesExecutor;
import org.sing_group.seda.cga.execution.CgaCompiPipelineConfiguration;
import org.sing_group.seda.cga.execution.CgaPipeline;
import org.sing_group.seda.cga.execution.CgaPipelineParameters;
import org.sing_group.seda.cga.transformation.dataset.CgaResults;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.datatype.SequencesGroupDataset;
import org.sing_group.seda.transformation.TransformationException;
import org.sing_group.seda.transformation.dataset.SequencesGroupDatasetTransformation;

public class CgaPipelineSequencesGroupDatasetTransformation
implements SequencesGroupDatasetTransformation {
    private DatatypeFactory factory;
    private CgaCompiPipelineConfiguration configuration;
    private File referenceFasta;
    private CgaResults cgaResults;
    private String additionalCompiParameters;
    private CgaBinariesExecutor dockerCgaBinariesExecutor;

    public CgaPipelineSequencesGroupDatasetTransformation(DatatypeFactory factory, CgaCompiPipelineConfiguration configuration, File referenceFasta, CgaResults cgaResults, String additionalCompiParameters, CgaBinariesExecutor dockerCgaBinariesExecutor) {
        this.factory = factory;
        this.configuration = configuration;
        this.referenceFasta = referenceFasta;
        this.cgaResults = cgaResults;
        this.additionalCompiParameters = additionalCompiParameters;
        this.dockerCgaBinariesExecutor = dockerCgaBinariesExecutor;
    }

    @Override
    public SequencesGroupDataset transform(SequencesGroupDataset dataset) throws TransformationException {
        try {
            return this.runPipeline(dataset);
        }
        catch (IOException | InterruptedException e) {
            throw new TransformationException("Error while running CGA. " + e.getMessage());
        }
    }

    private SequencesGroupDataset runPipeline(SequencesGroupDataset dataset) throws IOException, InterruptedException {
        SequencesGroup reference = this.factory.newSequencesGroup(this.referenceFasta.toPath());
        LinkedList<SequencesGroup> results = new LinkedList<SequencesGroup>();
        for (SequencesGroup sequencesGroup : dataset.getSequencesGroups().collect(Collectors.toList())) {
            File temporaryWorkingDir = Files.createTempDirectory(sequencesGroup.getName(), new FileAttribute[0]).toFile();
            new CgaPipeline(this.dockerCgaBinariesExecutor, new CgaPipelineParameters(temporaryWorkingDir, this.configuration, this.additionalCompiParameters), sequencesGroup, reference).run();
            results.add(this.factory.newSequencesGroup(this.newSequencesGroupName(sequencesGroup.getName()), sequencesGroup.getProperties(), this.getResults(temporaryWorkingDir)));
        }
        return this.factory.newSequencesGroupDataset(results.toArray(new SequencesGroup[results.size()]));
    }

    private String newSequencesGroupName(String name) {
        return name + "_" + this.cgaResults.getResultsFile().replace("/", "_");
    }

    private List<Sequence> getResults(File workingDir) {
        return this.factory.newSequencesGroup(new File(workingDir, this.cgaResults.getResultsFile()).toPath()).getSequences().collect(Collectors.toList());
    }
}

