/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.splign.gui;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.sing_group.gc4s.ui.CardsPanel;
import org.sing_group.gc4s.ui.CardsPanelBuilder;
import org.sing_group.seda.gui.execution.BinaryConfigurationPanelListener;
import org.sing_group.seda.gui.execution.BinaryExecutionConfigurationPanel;
import org.sing_group.seda.splign.execution.DefaultSplignCompartBinariesExecutor;
import org.sing_group.seda.splign.execution.DockerSplignCompartBinariesExecutor;
import org.sing_group.seda.splign.execution.SplignCompartBinariesExecutor;
import org.sing_group.seda.splign.gui.DockerExecutionConfigurationPanel;
import org.sing_group.seda.splign.gui.SystemBinaryExecutionConfigurationPanel;

public class SplignCompartExecutionConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String CARD_SYSTEM_BINARY = "System binary";
    private static final String CARD_DOCKER_IMAGE = "Docker image";
    private CardsPanel splignCompartExecutableCardsPanel;
    private DockerExecutionConfigurationPanel dockerExecutionConfigurationPanel;
    private SystemBinaryExecutionConfigurationPanel systemBinaryExecutionConfigurationPanel;
    private BinaryConfigurationPanelListener<SplignCompartBinariesExecutor> splignCompartExecutorChanged;

    public SplignCompartExecutionConfigurationPanel(BinaryConfigurationPanelListener<SplignCompartBinariesExecutor> binaryConfigurationPanelListener) {
        this.splignCompartExecutorChanged = binaryConfigurationPanelListener;
        this.init();
    }

    private void init() {
        this.systemBinaryExecutionConfigurationPanel = new SystemBinaryExecutionConfigurationPanel();
        this.systemBinaryExecutionConfigurationPanel.addBinaryConfigurationPanelListener(this.splignCompartExecutorChanged);
        this.dockerExecutionConfigurationPanel = new DockerExecutionConfigurationPanel();
        this.dockerExecutionConfigurationPanel.addBinaryConfigurationPanelListener(this.splignCompartExecutorChanged);
        CardsPanelBuilder builder = CardsPanelBuilder.newBuilder().withCard((Object)CARD_DOCKER_IMAGE, (Component)this.dockerExecutionConfigurationPanel).withSelectedCard(CARD_DOCKER_IMAGE).disableSelectionWithOneCard(true);
        if (!System.getProperty("seda.local.execution.enabled", "true").equals("false") && !System.getProperty("seda.local.execution.enabled.spligncompart", "true").equals("false")) {
            builder = builder.withCard((Object)CARD_SYSTEM_BINARY, (Component)this.systemBinaryExecutionConfigurationPanel);
        }
        this.splignCompartExecutableCardsPanel = builder.withSelectionLabel("Execution mode").build();
        this.splignCompartExecutableCardsPanel.setBorder((Border)BorderFactory.createTitledBorder("Splign/Compart configuration"));
        this.splignCompartExecutableCardsPanel.addPropertyChangeListener("gc4s.cardspanel.visiblecard", this::splignCompartBinaryExecutorCardChanged);
        this.add((Component)this.splignCompartExecutableCardsPanel);
    }

    private void splignCompartBinaryExecutorCardChanged(PropertyChangeEvent event) {
        this.splignCompartExecutorChanged.onBinariesExecutorChanged(this.getSelectedCard());
    }

    public Optional<SplignCompartBinariesExecutor> getBinariesExecutor() {
        return this.getSelectedCard().getBinariesExecutor();
    }

    public BinaryExecutionConfigurationPanel<SplignCompartBinariesExecutor> getSelectedCard() {
        BinaryExecutionConfigurationPanel selectedCard = (BinaryExecutionConfigurationPanel)((Object)this.splignCompartExecutableCardsPanel.getSelectedCard());
        return selectedCard;
    }

    public void setBinariesExecutor(SplignCompartBinariesExecutor binariesExecutor) {
        if (binariesExecutor instanceof DockerSplignCompartBinariesExecutor) {
            this.dockerExecutionConfigurationPanel.setSelectedDockerImage(((DockerSplignCompartBinariesExecutor)binariesExecutor).getDockerImage());
            this.splignCompartExecutableCardsPanel.setSelectedCard((Object)CARD_DOCKER_IMAGE);
        } else if (binariesExecutor instanceof DefaultSplignCompartBinariesExecutor) {
            File directory = ((DefaultSplignCompartBinariesExecutor)binariesExecutor).getSplignCompartDirectory();
            if (directory != null) {
                this.systemBinaryExecutionConfigurationPanel.setSelectedFile(directory);
            } else {
                this.systemBinaryExecutionConfigurationPanel.clearSelectedFile();
            }
            this.splignCompartExecutableCardsPanel.setSelectedCard((Object)CARD_SYSTEM_BINARY);
        } else {
            throw new IllegalStateException("Unknown SplignCompartBinariesExecutor implementation");
        }
    }
}

