/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.splign.execution;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Optional;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.sing_group.seda.splign.execution.AbstractSplignCompartBinariesExecutor;
import org.sing_group.seda.splign.execution.SplignCompartEnvironment;

@XmlRootElement
public class DefaultSplignCompartBinariesExecutor
extends AbstractSplignCompartBinariesExecutor {
    @XmlTransient
    private final SplignCompartEnvironment environment = SplignCompartEnvironment.getInstance();
    @XmlElement
    private final File splignCompartDirectory;
    @XmlTransient
    private Optional<Path> directoryPath;

    public DefaultSplignCompartBinariesExecutor() {
        this(null);
    }

    public DefaultSplignCompartBinariesExecutor(File splignCompartDirectory) {
        this.splignCompartDirectory = splignCompartDirectory;
    }

    private Optional<Path> getDirectoryPath() {
        if (this.directoryPath == null) {
            this.directoryPath = this.splignCompartDirectory == null ? Optional.empty() : Optional.of(this.splignCompartDirectory.toPath());
        }
        return this.directoryPath;
    }

    @Override
    public void mklds(File path) throws IOException, InterruptedException {
        super.mklds(Arrays.asList(this.composeCommand(this.environment.getSplignCommand())), path);
    }

    @Override
    public void ldsdir(File ldsdir, File comps, File ldsdirFile) throws IOException, InterruptedException {
        super.ldsdir(Arrays.asList(this.composeCommand(this.environment.getSplignCommand())), ldsdir, comps, ldsdirFile);
    }

    @Override
    public void compart(File qdb, File sdb, File compartmentsFile) throws IOException, InterruptedException {
        super.compart(Arrays.asList(this.composeCommand(this.environment.getCompartCommand())), qdb, sdb, compartmentsFile);
    }

    @Override
    protected String composeCommand(String command) {
        return this.getDirectoryPath().map(path -> path.resolve(command)).orElse(Paths.get(command, new String[0])).toString();
    }

    @Override
    protected String toFilePath(File file) {
        return file.getAbsolutePath();
    }

    public File getSplignCompartDirectory() {
        return this.splignCompartDirectory;
    }
}

