/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.pfam.transformations.provider;

import java.util.LinkedList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.pfam.PfamScanRequestConfiguration;
import org.sing_group.seda.pfam.PfamScanSequenceErrorPolicy;
import org.sing_group.seda.pfam.transformations.PfamScanSequencesGroupDatasetTransformation;
import org.sing_group.seda.pfam.transformations.PfamScanSequencesGroupTransformation;
import org.sing_group.seda.pfam.transformations.provider.PfamScanTransformationConfigurationChangeType;
import org.sing_group.seda.plugin.spi.AbstractTransformationProvider;
import org.sing_group.seda.plugin.spi.DefaultValidation;
import org.sing_group.seda.plugin.spi.Validation;
import org.sing_group.seda.transformation.dataset.SequencesGroupDatasetTransformation;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PfamScanTransformationProvider
extends AbstractTransformationProvider {
    @XmlElement
    private String eMail;
    @XmlElement
    private boolean activeSitePrediction;
    @XmlElement
    private Double eValue;
    @XmlElement
    private PfamScanSequenceErrorPolicy errorPolicy;
    @XmlElement
    private int batchDelayFactor;

    public PfamScanTransformationProvider() {
    }

    public PfamScanTransformationProvider(boolean activeSitePredition, PfamScanSequenceErrorPolicy errorPolicy, int batchDelayFactor) {
        this.activeSitePrediction = activeSitePredition;
        this.errorPolicy = errorPolicy;
        this.batchDelayFactor = batchDelayFactor;
    }

    @Override
    public Validation validate() {
        LinkedList<String> validationErrors = new LinkedList<String>();
        if (this.eMail == null) {
            validationErrors.add("The e-mail can't be null");
        }
        if (this.errorPolicy == null) {
            validationErrors.add("The error policy can't be null");
        }
        if (this.eValue != null && this.eValue < 0.0) {
            validationErrors.add("The expectation value can't be lower than 0");
        }
        if (this.batchDelayFactor < 0) {
            validationErrors.add("The batch delay factor can't be lower than 0");
        }
        if (validationErrors.isEmpty()) {
            return new DefaultValidation(new String[0]);
        }
        return new DefaultValidation(validationErrors);
    }

    @Override
    public SequencesGroupDatasetTransformation getTransformation(DatatypeFactory factory) {
        return new PfamScanSequencesGroupDatasetTransformation(this.getPfamScanTransformation(factory));
    }

    private PfamScanSequencesGroupTransformation getPfamScanTransformation(DatatypeFactory factory) {
        return new PfamScanSequencesGroupTransformation(this.getPfamScanConfiguration(), factory);
    }

    private PfamScanRequestConfiguration getPfamScanConfiguration() {
        if (this.eValue != null) {
            return new PfamScanRequestConfiguration(this.eMail, "pfam-a", this.activeSitePrediction, this.errorPolicy, this.batchDelayFactor, this.eValue);
        }
        return new PfamScanRequestConfiguration(this.eMail, "pfam-a", this.activeSitePrediction, this.errorPolicy, this.batchDelayFactor);
    }

    public void setEmail(String eMail) {
        if (this.eMail == null || !this.eMail.equals(eMail)) {
            this.eMail = eMail;
            this.fireTransformationsConfigurationModelEvent(PfamScanTransformationConfigurationChangeType.EMAIL_CHANGED, this.eMail);
        }
    }

    public void clearEmail() {
        if (this.eMail != null) {
            this.eMail = null;
            this.fireTransformationsConfigurationModelEvent(PfamScanTransformationConfigurationChangeType.EMAIL_CHANGED, this.eMail);
        }
    }

    public String geteMail() {
        return this.eMail;
    }

    public void setActiveSitePrediction(boolean activeSitePrediction) {
        if (this.activeSitePrediction != activeSitePrediction) {
            this.activeSitePrediction = activeSitePrediction;
            this.fireTransformationsConfigurationModelEvent(PfamScanTransformationConfigurationChangeType.ACTIVE_SITE_PREDICTION_CHANGED, this.eMail);
        }
    }

    public boolean isActiveSitePrediction() {
        return this.activeSitePrediction;
    }

    public void setEvalue(Double eValue) {
        if (this.eValue == null || !this.eValue.equals(eValue)) {
            this.eValue = eValue;
            this.fireTransformationsConfigurationModelEvent(PfamScanTransformationConfigurationChangeType.EVALUE_CHANGED, this.eMail);
        }
    }

    public void clearEvalue() {
        if (this.eValue == null) {
            this.eValue = null;
            this.fireTransformationsConfigurationModelEvent(PfamScanTransformationConfigurationChangeType.EVALUE_CHANGED, this.eMail);
        }
    }

    public Double getEvalue() {
        return this.eValue;
    }

    public void setErrorPolicy(PfamScanSequenceErrorPolicy errorPolicy) {
        if (this.errorPolicy == null || !this.errorPolicy.equals((Object)errorPolicy)) {
            this.errorPolicy = errorPolicy;
            this.fireTransformationsConfigurationModelEvent(PfamScanTransformationConfigurationChangeType.ERROR_POLICY_CHANGED, this.eMail);
        }
    }

    public PfamScanSequenceErrorPolicy getErrorPolicy() {
        return this.errorPolicy;
    }

    public void setBatchDelayFactor(int batchDelayFactor) {
        if (this.batchDelayFactor != batchDelayFactor) {
            this.batchDelayFactor = batchDelayFactor;
            this.fireTransformationsConfigurationModelEvent(PfamScanTransformationConfigurationChangeType.BATCH_DELAY_CHANGED, this.eMail);
        }
    }

    public int getBatchDelayFactor() {
        return this.batchDelayFactor;
    }
}

