/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.pfam.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.util.LinkedList;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.sing_group.gc4s.event.DocumentAdapter;
import org.sing_group.gc4s.event.RunnableDocumentAdapter;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.gc4s.input.text.DoubleTextField;
import org.sing_group.gc4s.input.text.EmailJXTextField;
import org.sing_group.gc4s.input.text.JIntegerTextField;
import org.sing_group.gc4s.ui.CenteredJPanel;
import org.sing_group.gc4s.utilities.ColorUtils;
import org.sing_group.seda.pfam.PfamScanSequenceErrorPolicy;
import org.sing_group.seda.pfam.core.PfamScanSedaPluginInfo;
import org.sing_group.seda.pfam.transformations.provider.PfamScanTransformationProvider;

public class PfamScanTransformationConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Color COLOR_VALID_INPUT = UIManager.getColor("TextField.background");
    private PfamScanTransformationProvider transformationProvider;
    private EmailJXTextField eMailTf;
    private JCheckBox activeSitePredictionCb;
    private DoubleTextField eValue;
    private JComboBox<PfamScanSequenceErrorPolicy> errorPolicy;
    private JIntegerTextField batchDelayFactor;

    public PfamScanTransformationConfigurationPanel() {
        this.init();
        this.initTransformationProvider();
    }

    private void initTransformationProvider() {
        this.transformationProvider = new PfamScanTransformationProvider(this.activeSitePredictionCb.isSelected(), this.getErrorPolicy(), this.batchDelayFactor.getValue());
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainPanel(), "Center");
    }

    private JPanel getMainPanel() {
        return new CenteredJPanel((Component)new InputParametersPanel(this.getParameters()));
    }

    private InputParameter[] getParameters() {
        LinkedList<InputParameter> parameters = new LinkedList<InputParameter>();
        parameters.add(this.getEmailParameter());
        parameters.add(this.getActiveSitePredictionParameter());
        parameters.add(this.getEvalueParameter());
        parameters.add(this.getErrorPolicyParameter());
        parameters.add(this.getBatchDelayFactorParameter());
        return parameters.toArray(new InputParameter[parameters.size()]);
    }

    private InputParameter getEmailParameter() {
        this.eMailTf = new EmailJXTextField();
        this.eMailTf.setMinimumSize(new Dimension(250, 20));
        this.eMailTf.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void removeUpdate(DocumentEvent e) {
                PfamScanTransformationConfigurationPanel.this.eMailChanged();
            }

            public void insertUpdate(DocumentEvent e) {
                PfamScanTransformationConfigurationPanel.this.eMailChanged();
            }
        });
        return new InputParameter("E-mail:", (JComponent)this.eMailTf, PfamScanSedaPluginInfo.PARAM_EMAIL_HELP_GUI);
    }

    private void eMailChanged() {
        SwingUtilities.invokeLater(() -> {
            if (this.eMailTf.isValidInput()) {
                this.transformationProvider.setEmail(this.eMailTf.getText());
            } else {
                this.transformationProvider.clearEmail();
            }
        });
    }

    private InputParameter getActiveSitePredictionParameter() {
        this.activeSitePredictionCb = new JCheckBox();
        this.activeSitePredictionCb.addItemListener(this::activeSitePredictionChanged);
        return new InputParameter("Active site prediction:", (JComponent)this.activeSitePredictionCb, "Whether to predict active site residues for Pfam-A matches or not.");
    }

    private void activeSitePredictionChanged(ItemEvent event) {
        SwingUtilities.invokeLater(() -> this.transformationProvider.setActiveSitePrediction(this.activeSitePredictionCb.isSelected()));
    }

    private InputParameter getEvalueParameter() {
        this.eValue = new DoubleTextField(10.0);
        this.eValue.getDocument().addDocumentListener((DocumentListener)new RunnableDocumentAdapter(this::expectValueChanged));
        return new InputParameter("Expectation value:", (JComponent)this.eValue, "Optionally, the expectation value cut-off.");
    }

    private void expectValueChanged() {
        SwingUtilities.invokeLater(() -> {
            if (this.eValue.getText().isEmpty()) {
                this.transformationProvider.clearEvalue();
                this.eValue.setBackground(COLOR_VALID_INPUT);
            } else {
                try {
                    Double eValue = this.getExpectValue();
                    this.transformationProvider.setEvalue(eValue);
                    this.eValue.setBackground(eValue > 0.0 ? COLOR_VALID_INPUT : ColorUtils.COLOR_INVALID_INPUT);
                }
                catch (NumberFormatException e) {
                    this.transformationProvider.setEvalue(-1.0);
                    this.eValue.setBackground(ColorUtils.COLOR_INVALID_INPUT);
                }
            }
        });
    }

    private Double getExpectValue() {
        return Double.parseDouble(this.eValue.getText().replace(",", ""));
    }

    private InputParameter getErrorPolicyParameter() {
        this.errorPolicy = new JComboBox<PfamScanSequenceErrorPolicy>(PfamScanSequenceErrorPolicy.values());
        this.errorPolicy.setSelectedItem((Object)PfamScanSedaPluginInfo.DEFAULT_ERROR_POLICY);
        this.errorPolicy.addItemListener(this::errorPolicyChanged);
        return new InputParameter("Sequence error policy:", this.errorPolicy, PfamScanSedaPluginInfo.PARAM_ERROR_POLICY_HELP_GUI);
    }

    private void errorPolicyChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            SwingUtilities.invokeLater(() -> this.transformationProvider.setErrorPolicy(this.getErrorPolicy()));
        }
    }

    private PfamScanSequenceErrorPolicy getErrorPolicy() {
        return (PfamScanSequenceErrorPolicy)((Object)this.errorPolicy.getSelectedItem());
    }

    private InputParameter getBatchDelayFactorParameter() {
        this.batchDelayFactor = new JIntegerTextField(Integer.valueOf(1));
        this.batchDelayFactor.getDocument().addDocumentListener((DocumentListener)new RunnableDocumentAdapter(this::batchDelayFactorChanged));
        return new InputParameter("Batch delay factor:", (JComponent)this.batchDelayFactor, PfamScanSedaPluginInfo.PARAM_BATCH_DELAY_FACTOR_HELP_GUI);
    }

    private void batchDelayFactorChanged() {
        SwingUtilities.invokeLater(() -> {
            if (this.batchDelayFactor.getText().isEmpty()) {
                this.batchDelayFactor.setBackground(ColorUtils.COLOR_INVALID_INPUT);
                this.transformationProvider.setBatchDelayFactor(-1);
            } else {
                try {
                    int batchDelayFactoryValue = this.getBatchDelayFactor();
                    this.transformationProvider.setBatchDelayFactor(batchDelayFactoryValue);
                    this.batchDelayFactor.setBackground(batchDelayFactoryValue >= 0 ? COLOR_VALID_INPUT : ColorUtils.COLOR_INVALID_INPUT);
                }
                catch (NumberFormatException e) {
                    this.transformationProvider.setBatchDelayFactor(-1);
                    this.batchDelayFactor.setBackground(ColorUtils.COLOR_INVALID_INPUT);
                }
            }
        });
    }

    private Integer getBatchDelayFactor() {
        return Integer.parseInt(this.batchDelayFactor.getText());
    }

    public PfamScanTransformationProvider getTransformationProvider() {
        return this.transformationProvider;
    }

    public void setTransformationProvider(PfamScanTransformationProvider transformationProvider) {
        PfamScanSequenceErrorPolicy newErrorPolicy;
        this.transformationProvider = transformationProvider;
        String eMailValue = this.transformationProvider.geteMail();
        if (eMailValue != null) {
            this.eMailTf.setText(eMailValue);
        }
        this.activeSitePredictionCb.setSelected(this.transformationProvider.isActiveSitePrediction());
        Double newEvalue = this.transformationProvider.getEvalue();
        if (newEvalue != null) {
            this.eValue.setValue((Object)newEvalue);
        }
        if ((newErrorPolicy = this.transformationProvider.getErrorPolicy()) != null) {
            this.errorPolicy.setSelectedItem((Object)newErrorPolicy);
        }
        this.batchDelayFactor.setValue((Object)this.transformationProvider.getBatchDelayFactor());
    }
}

