/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.uniparc;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.common.Database;
import uk.ac.ebi.kraken.interfaces.uniparc.DatabaseCrossReference;
import uk.ac.ebi.kraken.model.factories.DefaultUniParcFactory;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.services.data.serializer.model.uniparc.AvroDBXRef;

public class DbXrefConverter
implements Converter<DatabaseCrossReference, AvroDBXRef> {
    private final DefaultUniParcFactory factory = DefaultUniParcFactory.getInstance();

    @Override
    public AvroDBXRef toAvro(DatabaseCrossReference u) {
        AvroDBXRef.Builder builder = AvroDBXRef.newBuilder();
        builder.setAccession(u.getAccession()).setChain(u.getChain()).setGeneName(u.getGeneName()).setGI(u.getGiNumber()).setInternalVersion(u.getInternalVersion()).setProteinName(u.getProteinName()).setTaxonomy(this.getTaxonomy(u)).setType(u.getDatabase().getName()).setVersion(u.getVersion()).setCreated(u.getCreated().getTime()).setUpdated(u.getUpdated().getTime()).setActive(u.isActive());
        if (!Strings.isNullOrEmpty((String)u.getProteome())) {
            builder.setProteome(u.getProteome());
        }
        if (!Strings.isNullOrEmpty((String)u.getProteomeComponent())) {
            builder.setProteomeComponent(u.getProteomeComponent());
        }
        return builder.build();
    }

    private List<Integer> getTaxonomy(DatabaseCrossReference u) {
        ArrayList<Integer> taxs = new ArrayList<Integer>();
        taxs.add(u.getTaxonomyId());
        if (!u.getExtraTaxonomyIds().isEmpty()) {
            taxs.addAll(u.getExtraTaxonomyIds());
        }
        return taxs;
    }

    @Override
    public DatabaseCrossReference fromAvro(AvroDBXRef a) {
        List<Integer> taxids;
        DatabaseCrossReference xref = this.factory.buildDatabaseCrossReference();
        xref.setAccession(a.getAccession().toString());
        xref.setActive(a.getActive());
        xref.setInternalVersion(a.getInternalVersion());
        xref.setVersion(a.getVersion());
        xref.setActive(a.getActive());
        if (a.getChain() != null) {
            xref.setChain(a.getChain().toString());
        }
        if (a.getGeneName() != null) {
            xref.setGeneName(a.getGeneName().toString());
        }
        if (a.getProteinName() != null) {
            xref.setProteinName(a.getProteinName().toString());
        }
        if (a.getGI() != null) {
            xref.setGiNumber(a.getGI().toString());
        }
        Database database = this.factory.buildDatabase();
        database.setName(a.getType().toString());
        database.setVersion(a.getVersion());
        xref.setDatabase(database);
        if (a.getCreated() != null) {
            xref.setCreated(new Date(a.getCreated()));
        }
        if (a.getUpdated() != null) {
            xref.setUpdated(new Date(a.getUpdated()));
        }
        if (!(taxids = a.getTaxonomy()).isEmpty()) {
            xref.setTaxonomyId(taxids.get(0));
            if (taxids.size() > 1) {
                List<Integer> exTax = taxids.subList(1, taxids.size());
                xref.setExtraTaxonomyIds(exTax);
            }
        }
        if (a.getProteome() != null) {
            xref.setProteome(a.getProteome().toString());
        }
        if (a.getProteomeComponent() != null) {
            xref.setProteomeComponent(a.getProteomeComponent().toString());
        }
        return xref;
    }
}

