/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.proteome;

import java.util.stream.Collectors;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.uniprot.dataservice.domain.proteome.jaxb.CanonicalGene;
import uk.ac.ebi.uniprot.dataservice.domain.proteome.jaxb.ComponentType;
import uk.ac.ebi.uniprot.dataservice.domain.proteome.jaxb.DbReferenceType;
import uk.ac.ebi.uniprot.dataservice.domain.proteome.jaxb.Proteome;
import uk.ac.ebi.uniprot.dataservice.domain.proteome.jaxb.RedundantProteomeType;
import uk.ac.ebi.uniprot.dataservice.domain.proteome.jaxb.ReferenceType;
import uk.ac.ebi.uniprot.dataservice.domain.proteome.jaxb.SuperregnumType;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.proteome.AvroCanonicalGeneConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.proteome.AvroComponentConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.proteome.AvroRedundantProteomeConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.proteome.AvroReferenceConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.proteome.AvroXrefConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.proteome.AvroCanonicalGene;
import uk.ac.ebi.uniprot.services.data.serializer.model.proteome.AvroComponent;
import uk.ac.ebi.uniprot.services.data.serializer.model.proteome.AvroProteome;
import uk.ac.ebi.uniprot.services.data.serializer.model.proteome.AvroRedundantProteome;
import uk.ac.ebi.uniprot.services.data.serializer.model.proteome.AvroReference;
import uk.ac.ebi.uniprot.services.data.serializer.model.proteome.AvroSuperRegnumType;
import uk.ac.ebi.uniprot.services.data.serializer.model.proteome.AvroXref;

public class AvroProteomeConverter
implements Converter<Proteome, AvroProteome> {
    private final AvroCanonicalGeneConverter canonicalGeneConverter = new AvroCanonicalGeneConverter();
    private final SuperregnumConverter superregnumConverter = new SuperregnumConverter();
    private final AvroComponentConverter componentConverter = new AvroComponentConverter();
    private final AvroXrefConverter xrefConverter = new AvroXrefConverter();
    private final AvroRedundantProteomeConverter redProtConverter = new AvroRedundantProteomeConverter();
    private final AvroReferenceConverter referenceConverter = new AvroReferenceConverter();
    private static final Logger logger = LoggerFactory.getLogger(AvroProteomeConverter.class);

    @Override
    public AvroProteome toAvro(Proteome proteome) {
        AvroProteome.Builder builder = AvroProteome.newBuilder();
        builder.setName(proteome.getName());
        builder.setUpid(proteome.getUpid());
        builder.setTaxonomy(proteome.getTaxonomy());
        builder.setDescription(proteome.getDescription());
        builder.setSuperregnum(this.superregnumConverter.toAvro(proteome.getSuperregnum()));
        builder.setIsRepProteome(proteome.isIsRepresentativeProteome());
        builder.setIsRefProteome(proteome.isIsReferenceProteome());
        if (proteome.getSource() != null && !proteome.getSource().isEmpty()) {
            builder.setSource(proteome.getSource());
        }
        if (proteome.getSourceTaxonomy() != null) {
            builder.setSourceTaxonomy(proteome.getSourceTaxonomy());
        }
        if (proteome.getModified() != null) {
            builder.setModified(proteome.getModified().toString());
        }
        if (proteome.getRedundantTo() != null && !proteome.getRedundantTo().isEmpty()) {
            builder.setRedundantTo(proteome.getRedundantTo());
        }
        if (proteome.getStrain() != null && !proteome.getStrain().isEmpty()) {
            builder.setStrain(proteome.getStrain());
        }
        if (proteome.getIsolate() != null && !proteome.getIsolate().isEmpty()) {
            builder.setIsolate(proteome.getIsolate());
        }
        if (proteome.getCanonicalGene() != null && !proteome.getCanonicalGene().isEmpty()) {
            builder.setCanonicalGenes(proteome.getCanonicalGene().stream().map(val -> this.canonicalGeneConverter.toAvro((CanonicalGene)val)).collect(Collectors.toList()));
        }
        builder.setComponents(proteome.getComponent().stream().map(val -> this.componentConverter.toAvro((ComponentType)val)).collect(Collectors.toList()));
        if (proteome.getDbReference() != null && !proteome.getDbReference().isEmpty()) {
            builder.setDbXrefs(proteome.getDbReference().stream().map(val -> this.xrefConverter.toAvro((DbReferenceType)val)).collect(Collectors.toList()));
        }
        if (proteome.getRedundantProteome() != null && !proteome.getRedundantProteome().isEmpty()) {
            builder.setRedundantProteomes(proteome.getRedundantProteome().stream().map(val -> this.redProtConverter.toAvro((RedundantProteomeType)val)).collect(Collectors.toList()));
        }
        if (proteome.getReference() != null && !proteome.getReference().isEmpty()) {
            builder.setReferences(proteome.getReference().stream().map(val -> this.referenceConverter.toAvro((ReferenceType)val)).collect(Collectors.toList()));
        }
        return builder.build();
    }

    @Override
    public Proteome fromAvro(AvroProteome avro) {
        Proteome proteome = new Proteome();
        proteome.setName(avro.getName().toString());
        proteome.setUpid(avro.getUpid().toString());
        proteome.setTaxonomy(avro.getTaxonomy());
        if (avro.getDescription() != null) {
            proteome.setDescription(avro.getDescription().toString());
        }
        proteome.setSuperregnum(this.superregnumConverter.fromAvro(avro.getSuperregnum()));
        proteome.setIsReferenceProteome(avro.getIsRefProteome());
        proteome.setIsRepresentativeProteome(avro.getIsRepProteome());
        if (avro.getModified() != null) {
            try {
                proteome.setModified(DatatypeFactory.newInstance().newXMLGregorianCalendar(avro.getModified().toString()));
            }
            catch (DatatypeConfigurationException e) {
                logger.error("parse date failed", (Throwable)e);
            }
        }
        if (avro.getSource() != null) {
            proteome.setSource(avro.getSource().toString());
        }
        if (avro.getSourceTaxonomy() != null) {
            proteome.setSourceTaxonomy(avro.getSourceTaxonomy());
        }
        if (avro.getRedundantTo() != null) {
            proteome.setRedundantTo(avro.getRedundantTo().toString());
        }
        if (avro.getStrain() != null) {
            proteome.setStrain(avro.getStrain().toString());
        }
        if (avro.getIsolate() != null) {
            proteome.setIsolate(avro.getIsolate().toString());
        }
        if (avro.getCanonicalGenes() != null) {
            avro.getCanonicalGenes().stream().map(val -> this.canonicalGeneConverter.fromAvro((AvroCanonicalGene)((Object)val))).forEach(val -> proteome.getCanonicalGene().add((CanonicalGene)val));
        }
        avro.getComponents().stream().map(val -> this.componentConverter.fromAvro((AvroComponent)((Object)val))).forEach(val -> proteome.getComponent().add((ComponentType)val));
        if (avro.getDbXrefs() != null) {
            avro.getDbXrefs().stream().map(val -> this.xrefConverter.fromAvro((AvroXref)((Object)val))).forEach(val -> proteome.getDbReference().add((DbReferenceType)val));
        }
        if (avro.getRedundantProteomes() != null) {
            avro.getRedundantProteomes().stream().map(val -> this.redProtConverter.fromAvro((AvroRedundantProteome)((Object)val))).forEach(val -> proteome.getRedundantProteome().add((RedundantProteomeType)val));
        }
        if (avro.getReferences() != null) {
            avro.getReferences().stream().map(val -> this.referenceConverter.fromAvro((AvroReference)((Object)val))).forEach(val -> proteome.getReference().add((ReferenceType)val));
        }
        return proteome;
    }

    static class SuperregnumConverter
    implements Converter<SuperregnumType, AvroSuperRegnumType> {
        SuperregnumConverter() {
        }

        @Override
        public AvroSuperRegnumType toAvro(SuperregnumType srt) {
            switch (srt) {
                case EUKARYOTA: {
                    return AvroSuperRegnumType.eukaryota;
                }
                case BACTERIA: {
                    return AvroSuperRegnumType.bacteria;
                }
                case VIRUSES: {
                    return AvroSuperRegnumType.viruses;
                }
                case ARCHAEA: {
                    return AvroSuperRegnumType.archaea;
                }
            }
            throw new IllegalArgumentException("SuperregnumType " + srt.toString() + " is not mapped");
        }

        @Override
        public SuperregnumType fromAvro(AvroSuperRegnumType avro) {
            switch (avro) {
                case eukaryota: {
                    return SuperregnumType.EUKARYOTA;
                }
                case bacteria: {
                    return SuperregnumType.BACTERIA;
                }
                case viruses: {
                    return SuperregnumType.VIRUSES;
                }
                case archaea: {
                    return SuperregnumType.ARCHAEA;
                }
            }
            throw new IllegalArgumentException("AvroSuperRegnumType " + avro.toString() + " is not mapped");
        }
    }
}

