/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.comment;

import uk.ac.ebi.kraken.interfaces.factories.CommentFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PhysiologicalDirectionType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PhysiologicalReaction;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.EvidenceConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.comment.ReactionReferenceConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.cc.AvroPhysioReaction;

public class PhysiologicalReactionConverter
implements Converter<PhysiologicalReaction, AvroPhysioReaction> {
    private final CommentFactory factory = DefaultCommentFactory.getInstance();
    private final EvidenceConverter evidenceConverter = new EvidenceConverter();
    private final ReactionReferenceConverter referenceConverter = new ReactionReferenceConverter();

    @Override
    public AvroPhysioReaction toAvro(PhysiologicalReaction u) {
        AvroPhysioReaction.Builder builder = AvroPhysioReaction.newBuilder();
        builder.setType(u.getDirectionType().toDisplayName()).setEvidences(this.evidenceConverter.toAvro(u.getEvidenceIds()));
        if (u.getReactionReference() != null) {
            builder.setReactionReferences(this.referenceConverter.toAvro(u.getReactionReference()));
        }
        return builder.build();
    }

    @Override
    public PhysiologicalReaction fromAvro(AvroPhysioReaction a) {
        PhysiologicalReaction pr = this.factory.buildPhysiologicalReaction();
        pr.setDirectionType(PhysiologicalDirectionType.typeOf(a.getType().toString()));
        pr.setEvidenceIds(this.evidenceConverter.fromAvro(a.getEvidences()));
        if (a.getReactionReferences() != null) {
            pr.setReactionReference(this.referenceConverter.fromAvro(a.getReactionReferences()));
        }
        return pr;
    }
}

