/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.comment;

import java.util.List;
import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.factories.CommentFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.EvidencedValue;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AbsorptionNote;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.ConverterHelper;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.EvidenceConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.EvidencedStringConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.cc.Absorption;
import uk.ac.ebi.uniprot.services.data.serializer.model.ev.EvidencedString;

public class BPCPAbsorptionConverter
implements Converter<uk.ac.ebi.kraken.interfaces.uniprot.comments.Absorption, Absorption> {
    private final EvidencedStringConverter evidencedStringConverter = new EvidencedStringConverter();
    private final CommentFactory factory = DefaultCommentFactory.getInstance();
    private final EvidenceConverter evidenceConverter = new EvidenceConverter();

    @Override
    public Absorption toAvro(uk.ac.ebi.kraken.interfaces.uniprot.comments.Absorption absorption) {
        Absorption.Builder abBuilder = Absorption.newBuilder();
        abBuilder.setApproximate(absorption.isApproximation());
        if (absorption.hasNote()) {
            abBuilder.setNote(absorption.getNote().getTexts().stream().map(v -> this.evidencedStringConverter.fromAvro((EvidencedValue)v)).collect(Collectors.toList()));
        }
        abBuilder.setMax(ConverterHelper.convert("" + absorption.getMax(), absorption.getEvidenceIds()));
        return abBuilder.build();
    }

    @Override
    public uk.ac.ebi.kraken.interfaces.uniprot.comments.Absorption fromAvro(Absorption absorption) {
        uk.ac.ebi.kraken.interfaces.uniprot.comments.Absorption abp = this.factory.buildAbsorption();
        abp.setMax(Integer.parseInt(absorption.getMax().getKey().toString()));
        abp.setEvidenceIds(this.evidenceConverter.fromAvro(absorption.getMax().getEvidence()));
        abp.setApproximation(absorption.getApproximate());
        if (absorption.getNote() != null) {
            AbsorptionNote note = this.factory.buildAbsorptionNote();
            List<EvidencedValue> evValues = absorption.getNote().stream().map(v -> this.evidencedStringConverter.toAvro((EvidencedString)((Object)v))).collect(Collectors.toList());
            note.setTexts(evValues);
            abp.setNote(note);
        }
        return abp;
    }
}

