/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.avro.Schema;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.uniprot.services.data.serializer.model.entry.EntryObject;

public enum SchemaGenerator {
    INSTANCE;

    private Schema write_schema;
    private final String DEFAULT_SCHEMA_LOCATION = "https://www.ebi.ac.uk/~trembl/EntryObject.avsc";

    private SchemaGenerator() {
        this.init();
    }

    private void init() {
        URL url = null;
        try {
            Properties avroProperties = this.loadAvroConfigProperties();
            String avroSchemaLocation = avroProperties.getProperty("avroEntrySchemaLocation");
            if (avroSchemaLocation != null && !avroProperties.isEmpty()) {
                url = new URL(avroSchemaLocation);
            }
            try (InputStream is = url.openStream();){
                Schema.Parser parser = new Schema.Parser();
                this.write_schema = parser.parse(is);
                LoggerFactory.getLogger((String)SchemaGenerator.class.getName()).info("Loaded AvroSchema from " + url);
            }
        }
        catch (Exception e) {
            this.write_schema = EntryObject.SCHEMA$;
            LoggerFactory.getLogger((String)SchemaGenerator.class.getName()).info("Loaded AvroSchema from Local EntryObject");
        }
    }

    public Schema getWriteSchema() {
        if (this.write_schema == null) {
            return EntryObject.SCHEMA$;
        }
        return this.write_schema;
    }

    private Properties loadAvroConfigProperties() {
        Throwable throwable;
        InputStream propertyInputStream;
        Properties properties = new Properties();
        try {
            propertyInputStream = SchemaGenerator.class.getResourceAsStream("/common-avro-config.properties");
            throwable = null;
            try {
                if (propertyInputStream != null) {
                    properties.load(propertyInputStream);
                    LoggerFactory.getLogger((String)SchemaGenerator.class.getName()).info("Loaded common-avro-config.properties with getResourceAsStream");
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (propertyInputStream != null) {
                    if (throwable != null) {
                        try {
                            propertyInputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        propertyInputStream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger((String)SchemaGenerator.class.getName()).warn("Unable to load common-avro-config.properties with getResourceAsStream", (Throwable)e);
        }
        try {
            propertyInputStream = new FileInputStream("common-avro-config.properties");
            throwable = null;
            try {
                if (propertyInputStream != null) {
                    properties.load(propertyInputStream);
                    LoggerFactory.getLogger((String)SchemaGenerator.class.getName()).info("Loaded common-avro-config.properties with FileInputStream");
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (propertyInputStream != null) {
                    if (throwable != null) {
                        try {
                            propertyInputStream.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        propertyInputStream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger((String)SchemaGenerator.class.getName()).info("Unable to load common-avro-config.properties with FileInputStream");
        }
        return properties;
    }
}

