/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.uniref.impl;

import java.util.Collections;
import uk.ac.ebi.kraken.interfaces.factories.UniRefFactory;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefEntry;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefEntryName;
import uk.ac.ebi.kraken.interfaces.uniref.member.UniRefRepresentativeMember;
import uk.ac.ebi.kraken.model.factories.DefaultUniRefFactory;
import uk.ac.ebi.uniprot.dataservice.client.impl.ResponseAdaptor;
import uk.ac.ebi.uniprot.dataservice.client.uniref.UniRefComponent;
import uk.ac.ebi.uniprot.dataservice.client.uniref.impl.UniRefComponentImpl;
import uk.ac.ebi.uniprot.dataservice.client.uniref.impl.UniRefEntryAdaptor;
import uk.ac.ebi.uniprot.dataservice.document.uniref.UniRefDocument;

class ResponseAdaptors {
    static final UniRefEntryNameResponseAdaptor UNIREF_ENTRY_NAME_RESPONSE_ADAPTOR = new UniRefEntryNameResponseAdaptor();
    static final UniRefRepresentativeResponseAdaptor UNIREF_REPRESENTATIVE_RESPONSE_ADAPTOR = new UniRefRepresentativeResponseAdaptor();
    private static final UniRefFactory FACTORY = DefaultUniRefFactory.getInstance();

    ResponseAdaptors() {
    }

    static class UniRefRepresentativeResponseAdaptor
    implements ResponseAdaptor<UniRefComponent<UniRefRepresentativeMember>, UniRefDocument> {
        UniRefRepresentativeResponseAdaptor() {
        }

        @Override
        public UniRefComponent<UniRefRepresentativeMember> adapt(UniRefDocument doc) {
            return UniRefComponentImpl.getInstance(doc.clusterId, Collections.singletonList(this.covertToRepresentative(doc)));
        }

        private UniRefRepresentativeMember covertToRepresentative(UniRefDocument doc) {
            UniRefEntry entry = UniRefEntryAdaptor.getInstance().adapt(doc);
            return entry.getRepresentativeMember();
        }
    }

    static class UniRefEntryNameResponseAdaptor
    implements ResponseAdaptor<UniRefComponent<UniRefEntryName>, UniRefDocument> {
        UniRefEntryNameResponseAdaptor() {
        }

        @Override
        public UniRefComponent<UniRefEntryName> adapt(UniRefDocument doc) {
            return UniRefComponentImpl.getInstance(doc.clusterId, Collections.singletonList(FACTORY.buildUniRefEntryName(doc.clusterName)));
        }
    }
}

