/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.examples;

import java.time.Duration;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefDatabaseType;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefEntry;
import uk.ac.ebi.kraken.interfaces.uniref.member.UniProtAccession;
import uk.ac.ebi.kraken.interfaces.uniref.member.UniRefMember;
import uk.ac.ebi.uniprot.dataservice.client.Client;
import uk.ac.ebi.uniprot.dataservice.client.QueryResult;
import uk.ac.ebi.uniprot.dataservice.client.ServiceFactory;
import uk.ac.ebi.uniprot.dataservice.client.examples.PrintUtils;
import uk.ac.ebi.uniprot.dataservice.client.exception.ServiceException;
import uk.ac.ebi.uniprot.dataservice.client.uniref.UniRefQueryBuilder;
import uk.ac.ebi.uniprot.dataservice.client.uniref.UniRefService;
import uk.ac.ebi.uniprot.dataservice.query.Query;

public class UniRefSearchExamples {
    private static final int DISPLAY_ENTRY_SIZE = 10;

    public static void main(String[] args) throws ServiceException {
        LocalTime start = LocalTime.now();
        UniRefSearchExamples.driveExamples();
        LocalTime end = LocalTime.now();
        Duration duration = Duration.between(start, end);
        System.out.println("Duration=" + duration.getSeconds() + " seconds");
    }

    public static void driveExamples() {
        ServiceFactory serviceFactoryInstance = Client.getServiceFactoryInstance();
        UniRefService uniRefService = serviceFactoryInstance.getUniRefQueryService();
        System.out.println("Staring up search service");
        uniRefService.start();
        try {
            UniRefSearchExamples.searchForUniRefClusterIdentifier(uniRefService);
            UniRefSearchExamples.searchForUniRefClusterName(uniRefService);
            UniRefSearchExamples.searchForUniRefDatabaseType(uniRefService);
            UniRefSearchExamples.searchForUniRefRepresentiveId(uniRefService);
            UniRefSearchExamples.searchForRepresentativeAccession(uniRefService);
            UniRefSearchExamples.searchForRepresentativeUpi(uniRefService);
            UniRefSearchExamples.searchForRepresentativeProteionName(uniRefService);
            UniRefSearchExamples.searchForMemberProteionName(uniRefService);
            UniRefSearchExamples.searchForMemberOrganismName(uniRefService);
            UniRefSearchExamples.searchForMemberTaxIdWithinOneDatabase(uniRefService);
        }
        catch (ServiceException e) {
            System.err.println("Error occurred whilst executing search" + e.getMessage());
        }
        finally {
            uniRefService.stop();
            System.out.println("service now stopped.");
        }
    }

    public static void searchForUniRefClusterIdentifier(UniRefService uniRefService) throws ServiceException {
        PrintUtils.printExampleHeader("UniRef identifier search");
        String uniRefClusterId = "UniRef100_P99999";
        System.out.printf("Search for UniRef entry with the given identifier: %s%n", uniRefClusterId);
        Query query = UniRefQueryBuilder.clusterId(uniRefClusterId);
        SearchExecutor searchExecutor = new SearchExecutor(uniRefService){

            @Override
            List<String> extractValues(UniRefEntry entry) {
                String uniRefId = entry.getUniRefEntryId().getValue();
                return Collections.singletonList(uniRefId);
            }
        };
        Map<String, List<String>> entries = searchExecutor.executeSearch(query);
        PrintUtils.printSearchResults(entries);
    }

    public static void searchForUniRefClusterName(UniRefService uniRefService) throws ServiceException {
        PrintUtils.printExampleHeader("UniRef cluster name search");
        String uniRefClusterName = "Cytochrome c";
        System.out.printf("Search for UniRef entry with the given name: %s%n", uniRefClusterName);
        Query query = UniRefQueryBuilder.clusterName(uniRefClusterName);
        SearchExecutor searchExecutor = new SearchExecutor(uniRefService){

            @Override
            List<String> extractValues(UniRefEntry entry) {
                String uniRefName = entry.getName().getValue();
                return Collections.singletonList(uniRefName);
            }
        };
        Map<String, List<String>> entries = searchExecutor.executeSearch(query, 10);
        PrintUtils.printSearchResults(entries);
    }

    public static void searchForUniRefDatabaseType(UniRefService uniRefService) throws ServiceException {
        PrintUtils.printExampleHeader("UniRef database type search");
        UniRefDatabaseType uniRefDatabaseType = UniRefDatabaseType.UniRef100;
        System.out.printf("Search for UniRef entry with the given database type: %s%n", uniRefDatabaseType.name());
        Query query = UniRefQueryBuilder.uniRefClusterDatabase(uniRefDatabaseType);
        SearchExecutor searchExecutor = new SearchExecutor(uniRefService){

            @Override
            List<String> extractValues(UniRefEntry entry) {
                String uniRefDatabaseType = entry.getUniRefDatabase().getType().name();
                return Collections.singletonList(uniRefDatabaseType);
            }
        };
        Map<String, List<String>> entries = searchExecutor.executeSearch(query, 10);
        PrintUtils.printSearchResults(entries);
    }

    public static void searchForUniRefRepresentiveId(UniRefService uniRefService) throws ServiceException {
        PrintUtils.printExampleHeader("UniRef representative id search");
        String uniRefRepId = "CYC_HUMAN";
        System.out.printf("Search for UniRef entry with the given representative id: %s%n", uniRefRepId);
        Query query = UniRefQueryBuilder.representativeId(uniRefRepId);
        SearchExecutor searchExecutor = new SearchExecutor(uniRefService){

            @Override
            List<String> extractValues(UniRefEntry entry) {
                String uniRefName = entry.getRepresentativeMember().getMemberId().getValue();
                return Collections.singletonList(uniRefName);
            }
        };
        Map<String, List<String>> entries = searchExecutor.executeSearch(query, 10);
        PrintUtils.printSearchResults(entries);
    }

    public static void searchForRepresentativeAccession(UniRefService uniRefService) throws ServiceException {
        PrintUtils.printExampleHeader("UniRef representative UniProt accession search");
        String uniRefRepUniProtAccession = "P99999";
        System.out.printf("Search for UniRef entry with the given representative UniProt accession: %s%n", uniRefRepUniProtAccession);
        Query query = UniRefQueryBuilder.representativeAccession(uniRefRepUniProtAccession);
        SearchExecutor searchExecutor = new SearchExecutor(uniRefService){

            @Override
            List<String> extractValues(UniRefEntry entry) {
                String uniRefRepresentative = UniRefSearchExamples.memberToString(entry.getRepresentativeMember());
                return Collections.singletonList(uniRefRepresentative);
            }
        };
        Map<String, List<String>> entries = searchExecutor.executeSearch(query, 10);
        PrintUtils.printSearchResults(entries);
    }

    private static String memberToString(UniRefMember member) {
        StringBuilder sb = new StringBuilder();
        sb.append(member.getType().getValue()).append("; ");
        sb.append(member.getMemberId().getValue()).append("; ");
        boolean isFirst = true;
        for (UniProtAccession acc : member.getUniProtAccessions()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(",");
            }
            sb.append(acc.getValue());
        }
        sb.append("; ");
        sb.append(member.getUniParcAccession().getValue()).append("; ");
        sb.append(member.getUniRef100EntryId().getValue()).append("; ");
        sb.append(member.getUniRef90EntryId().getValue()).append("; ");
        sb.append(member.getUniRef50EntryId().getValue()).append("; ");
        sb.append(member.getProteinName().getValue()).append("; ");
        sb.append(member.getNCBITaxonomy().getValue()).append("; ");
        sb.append(member.getLength()).append("; ");
        sb.append(member.getSourceOrganism().getValue()).append("; ");
        if (member.isSeed()) {
            sb.append("1");
        } else {
            sb.append("0");
        }
        return sb.toString();
    }

    public static void searchForRepresentativeUpi(UniRefService uniRefService) throws ServiceException {
        PrintUtils.printExampleHeader("UniRef representive UPI search");
        String uniRefRepUpi = "UPI000013EAA0";
        System.out.printf("Search for UniRef entry with the given representative UPI: %s%n", uniRefRepUpi);
        Query query = UniRefQueryBuilder.representativeAccession(uniRefRepUpi);
        SearchExecutor searchExecutor = new SearchExecutor(uniRefService){

            @Override
            List<String> extractValues(UniRefEntry entry) {
                String uniRefRepresentative = UniRefSearchExamples.memberToString(entry.getRepresentativeMember());
                return Collections.singletonList(uniRefRepresentative);
            }
        };
        Map<String, List<String>> entries = searchExecutor.executeSearch(query, 10);
        PrintUtils.printSearchResults(entries);
    }

    public static void searchForRepresentativeProteionName(UniRefService uniRefService) throws ServiceException {
        PrintUtils.printExampleHeader("UniRef representative protein name search");
        String uniRefRepProteinName = " Cytochrome c";
        System.out.printf("Search for UniRef entry with the given representative protein name: %s%n", uniRefRepProteinName);
        Query query = UniRefQueryBuilder.representativeProteinName(uniRefRepProteinName);
        SearchExecutor searchExecutor = new SearchExecutor(uniRefService){

            @Override
            List<String> extractValues(UniRefEntry entry) {
                String uniRefRepresentative = UniRefSearchExamples.memberToString(entry.getRepresentativeMember());
                return Collections.singletonList(uniRefRepresentative);
            }
        };
        Map<String, List<String>> entries = searchExecutor.executeSearch(query, 10);
        PrintUtils.printSearchResults(entries);
    }

    public static void searchForMemberProteionName(UniRefService uniRefService) throws ServiceException {
        PrintUtils.printExampleHeader("UniRef member protein name search");
        String uniRefMemberProteinName = "Cytochrome c";
        System.out.printf("Search for UniRef entry with the given member protein name: %s%n", uniRefMemberProteinName);
        Query query = UniRefQueryBuilder.memberProteinName(uniRefMemberProteinName);
        SearchExecutor searchExecutor = new SearchExecutor(uniRefService){

            @Override
            List<String> extractValues(UniRefEntry entry) {
                ArrayList<String> membersString = new ArrayList<String>();
                String uniRefRepresentative = UniRefSearchExamples.memberToString(entry.getRepresentativeMember());
                membersString.add(uniRefRepresentative);
                List<UniRefMember> members = entry.getMembers();
                for (UniRefMember member : members) {
                    String uniRefMember = UniRefSearchExamples.memberToString(member);
                    membersString.add(uniRefMember);
                }
                return membersString;
            }
        };
        Map<String, List<String>> entries = searchExecutor.executeSearch(query, 10);
        PrintUtils.printSearchResults(entries);
    }

    public static void searchForMemberOrganismName(UniRefService uniRefService) throws ServiceException {
        PrintUtils.printExampleHeader("UniRef member organism name search");
        String uniRefMemberOrganismName = "Gorilla gorilla gorilla";
        System.out.printf("Search for UniRef entry with the given member organism name: %s%n", uniRefMemberOrganismName);
        Query query = UniRefQueryBuilder.memberProteinName(uniRefMemberOrganismName);
        SearchExecutor searchExecutor = new SearchExecutor(uniRefService){

            @Override
            List<String> extractValues(UniRefEntry entry) {
                ArrayList<String> membersString = new ArrayList<String>();
                String uniRefRepresentative = UniRefSearchExamples.memberToString(entry.getRepresentativeMember());
                membersString.add(uniRefRepresentative);
                List<UniRefMember> members = entry.getMembers();
                for (UniRefMember member : members) {
                    String uniRefMember = UniRefSearchExamples.memberToString(member);
                    membersString.add(uniRefMember);
                }
                return membersString;
            }
        };
        Map<String, List<String>> entries = searchExecutor.executeSearch(query, 10);
        PrintUtils.printSearchResults(entries);
    }

    public static void searchForMemberTaxIdWithinOneDatabase(UniRefService uniRefService) throws ServiceException {
        PrintUtils.printExampleHeader("UniRef member taxon ID search within one UniRef database");
        int uniRefMemberTaxId = 9606;
        UniRefDatabaseType uniRefDatabaseType = UniRefDatabaseType.UniRef50;
        System.out.printf("Search for UniRef entry with the given member taxId: %s within one UniRef databae%s%n", uniRefMemberTaxId, uniRefDatabaseType.name());
        Query query = UniRefQueryBuilder.memberTaxonId(uniRefMemberTaxId).and(UniRefQueryBuilder.uniRefClusterDatabase(uniRefDatabaseType));
        SearchExecutor searchExecutor = new SearchExecutor(uniRefService){

            @Override
            List<String> extractValues(UniRefEntry entry) {
                ArrayList<String> membersString = new ArrayList<String>();
                String uniRefRepresentative = UniRefSearchExamples.memberToString(entry.getRepresentativeMember());
                membersString.add(uniRefRepresentative);
                List<UniRefMember> members = entry.getMembers();
                for (UniRefMember member : members) {
                    String uniRefMember = UniRefSearchExamples.memberToString(member);
                    membersString.add(uniRefMember);
                }
                return membersString;
            }
        };
        Map<String, List<String>> entries = searchExecutor.executeSearch(query, 10);
        PrintUtils.printSearchResults(entries);
    }

    private static abstract class SearchExecutor {
        private static final int NO_LIMIT = Integer.MAX_VALUE;
        private final UniRefService uniRefService;

        public SearchExecutor(UniRefService uniRefService) {
            this.uniRefService = uniRefService;
        }

        Map<String, List<String>> executeSearch(Query query) throws ServiceException {
            return this.executeSearch(query, Integer.MAX_VALUE);
        }

        Map<String, List<String>> executeSearch(Query query, int limit) throws ServiceException {
            QueryResult<UniRefEntry> searchResult = this.uniRefService.getEntries(query);
            HashMap<String, List<String>> entries = new HashMap<String, List<String>>();
            while (searchResult.hasNext() && limit > 0) {
                UniRefEntry entry = (UniRefEntry)searchResult.next();
                String uniRefId = entry.getUniRefEntryId().getValue();
                entries.put(uniRefId, this.extractValues(entry));
                --limit;
            }
            return entries;
        }

        abstract List<String> extractValues(UniRefEntry var1);
    }
}

