/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl;

import com.google.inject.Singleton;
import javax.inject.Inject;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.BlastSummary;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.UniProtBlastSummary;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl.BlastAnnotations;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl.ConverterUtils;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl.SummaryConverter;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl.UniProtBlastSummaryImpl;
import uk.ac.ebi.uniprot.dataservices.jaxb.blast.THit;

@Singleton
class UniProtSummaryConverter
implements SummaryConverter<THit, UniProtBlastSummary> {
    private SummaryConverter<THit, BlastSummary> converter;

    @Inject
    public UniProtSummaryConverter(@BlastAnnotations.GenericSummaryConverter SummaryConverter<THit, BlastSummary> converter) {
        this.converter = converter;
    }

    @Override
    public UniProtBlastSummary convert(THit rawHitResult) {
        if (rawHitResult == null) {
            throw new IllegalArgumentException("Can not convert null raw result");
        }
        BlastSummary blastSummary = this.converter.convert(rawHitResult);
        UniProtBlastSummaryImpl hit = new UniProtBlastSummaryImpl(blastSummary);
        hit.entryAc = ConverterUtils.emptyIfNull(rawHitResult.getAc());
        return hit;
    }
}

