/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl;

import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.Alignment;

class AlignmentImpl
implements Alignment {
    int score;
    float bitScore;
    float zScore;
    int swScore;
    double expectation;
    float identity;
    float positives;
    float probability;
    float gaps;
    float ungaps;
    String strand;
    String querySeq;
    int querySeqStart;
    int querySeqEnd;
    String matchSeq;
    int matchSeqStart;
    int matchSeqEnd;
    String pattern;
    String overlap;

    AlignmentImpl() {
    }

    @Override
    public int getScore() {
        return this.score;
    }

    @Override
    public float getBitScore() {
        return this.bitScore;
    }

    @Override
    public double getExpectation() {
        return this.expectation;
    }

    @Override
    public float getIdentity() {
        return this.identity;
    }

    @Override
    public float getPositives() {
        return this.positives;
    }

    @Override
    public float getGaps() {
        return this.gaps;
    }

    @Override
    public String getStrand() {
        return this.strand;
    }

    @Override
    public String getQuerySeq() {
        return this.querySeq;
    }

    @Override
    public int getStartQuerySeq() {
        return this.querySeqStart;
    }

    @Override
    public int getEndQuerySeq() {
        return this.querySeqEnd;
    }

    @Override
    public String getMatchSeq() {
        return this.matchSeq;
    }

    @Override
    public int getStartMatchSeq() {
        return this.matchSeqStart;
    }

    @Override
    public int getEndMatchSeq() {
        return this.matchSeqEnd;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public float getZScore() {
        return this.zScore;
    }

    @Override
    public int getSmithWatermanScore() {
        return this.swScore;
    }

    @Override
    public String getOverlap() {
        return this.overlap;
    }

    @Override
    public float getUngaps() {
        return this.ungaps;
    }

    @Override
    public float getProbability() {
        return this.probability;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlignmentImpl alignment = (AlignmentImpl)o;
        if (this.score != alignment.score) {
            return false;
        }
        if (Float.compare(alignment.bitScore, this.bitScore) != 0) {
            return false;
        }
        if (Float.compare(alignment.zScore, this.zScore) != 0) {
            return false;
        }
        if (this.swScore != alignment.swScore) {
            return false;
        }
        if (Double.compare(alignment.expectation, this.expectation) != 0) {
            return false;
        }
        if (Float.compare(alignment.identity, this.identity) != 0) {
            return false;
        }
        if (Float.compare(alignment.positives, this.positives) != 0) {
            return false;
        }
        if (Float.compare(alignment.probability, this.probability) != 0) {
            return false;
        }
        if (Float.compare(alignment.gaps, this.gaps) != 0) {
            return false;
        }
        if (Float.compare(alignment.ungaps, this.ungaps) != 0) {
            return false;
        }
        if (this.querySeqStart != alignment.querySeqStart) {
            return false;
        }
        if (this.querySeqEnd != alignment.querySeqEnd) {
            return false;
        }
        if (this.matchSeqStart != alignment.matchSeqStart) {
            return false;
        }
        if (this.matchSeqEnd != alignment.matchSeqEnd) {
            return false;
        }
        if (!this.strand.equals(alignment.strand)) {
            return false;
        }
        if (!this.querySeq.equals(alignment.querySeq)) {
            return false;
        }
        if (!this.matchSeq.equals(alignment.matchSeq)) {
            return false;
        }
        if (!this.pattern.equals(alignment.pattern)) {
            return false;
        }
        return this.overlap.equals(alignment.overlap);
    }

    public int hashCode() {
        int result = this.score;
        result = 31 * result + (Float.compare(this.bitScore, Float.MIN_VALUE) != 0 ? Float.floatToIntBits(this.bitScore) : 0);
        result = 31 * result + (Float.compare(this.zScore, Float.MIN_VALUE) != 0 ? Float.floatToIntBits(this.zScore) : 0);
        result = 31 * result + this.swScore;
        long temp = Double.doubleToLongBits(this.expectation);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (Float.compare(this.identity, Float.MIN_VALUE) != 0 ? Float.floatToIntBits(this.identity) : 0);
        result = 31 * result + (Float.compare(this.positives, Float.MIN_VALUE) != 0 ? Float.floatToIntBits(this.positives) : 0);
        result = 31 * result + (Float.compare(this.probability, Float.MIN_VALUE) != 0 ? Float.floatToIntBits(this.probability) : 0);
        result = 31 * result + (Float.compare(this.gaps, Float.MIN_VALUE) != 0 ? Float.floatToIntBits(this.gaps) : 0);
        result = 31 * result + (Float.compare(this.ungaps, Float.MIN_VALUE) != 0 ? Float.floatToIntBits(this.ungaps) : 0);
        result = 31 * result + this.strand.hashCode();
        result = 31 * result + this.querySeq.hashCode();
        result = 31 * result + this.querySeqStart;
        result = 31 * result + this.querySeqEnd;
        result = 31 * result + this.matchSeq.hashCode();
        result = 31 * result + this.matchSeqStart;
        result = 31 * result + this.matchSeqEnd;
        result = 31 * result + this.pattern.hashCode();
        result = 31 * result + this.overlap.hashCode();
        return result;
    }

    public String toString() {
        return "AlignmentImpl{score=" + this.score + ", bitScore=" + this.bitScore + ", zScore=" + this.zScore + ", swScore=" + this.swScore + ", expectation=" + this.expectation + ", identity=" + this.identity + ", positives=" + this.positives + ", probability=" + this.probability + ", gaps=" + this.gaps + ", ungaps=" + this.ungaps + ", strand='" + this.strand + '\'' + ", querySeq='" + this.querySeq + '\'' + ", querySeqStart=" + this.querySeqStart + ", querySeqEnd=" + this.querySeqEnd + ", matchSeq='" + this.matchSeq + '\'' + ", matchSeqStart=" + this.matchSeqStart + ", matchSeqEnd=" + this.matchSeqEnd + ", pattern='" + this.pattern + '\'' + ", overlap='" + this.overlap + '\'' + '}';
    }
}

