/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl;

import com.google.common.base.Preconditions;
import java.util.concurrent.CompletableFuture;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.BlastInput;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.BlastResult;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.BlastService;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.Hit;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl.DispatcherSubmissionService;

abstract class AbstractBlastService<T extends Hit, S>
implements BlastService<T> {
    private final DispatcherSubmissionService<BlastInput, S> submissionService;

    public AbstractBlastService(DispatcherSubmissionService<BlastInput, S> submissionService) {
        this.submissionService = submissionService;
    }

    @Override
    public CompletableFuture<BlastResult<T>> runBlast(BlastInput input) {
        Preconditions.checkState((boolean)this.isStarted(), (Object)"Blast service has not been started");
        this.checkBlastInput(input);
        return this.submissionService.submitJob(input).thenApply(result -> this.buildBlastResult(result, input));
    }

    protected abstract void checkBlastInput(BlastInput var1);

    protected abstract BlastResult<T> buildBlastResult(S var1, BlastInput var2);
}

