/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.organism;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.factories.UniProtFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.NcbiTaxonomyId;
import uk.ac.ebi.kraken.interfaces.uniprot.Organism;
import uk.ac.ebi.kraken.interfaces.uniprot.OrganismHost;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.DbReferenceType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.OrganismType;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;
import uk.ac.ebi.kraken.xml.uniprot.organism.NameUpdater;

public class OrganismHostHandler
implements GenericHandler<List<OrganismHost>, List<OrganismType>> {
    private final UniProtFactory uniProtFactory;
    private final ObjectFactory objectFactory;
    private final EvidenceReferenceHandler evidencesHandler;
    private final NameUpdater nameUpdater;

    public OrganismHostHandler(UniProtFactory uniProtFactory, ObjectFactory objectFactory, EvidenceReferenceHandler evidencesHandler, NameUpdater nameUpdater) {
        this.uniProtFactory = uniProtFactory;
        this.objectFactory = objectFactory;
        this.evidencesHandler = evidencesHandler;
        this.nameUpdater = nameUpdater;
    }

    @Override
    public List<OrganismHost> fromXmlBinding(List<OrganismType> xmlOrganisms) {
        ArrayList<OrganismHost> organismHosts = new ArrayList<OrganismHost>();
        for (OrganismType xmlOrganismHost : xmlOrganisms) {
            Organism organism = this.uniProtFactory.buildOrganism();
            this.nameUpdater.fromXmlBinding(xmlOrganismHost, organism);
            OrganismHost organismHost = this.uniProtFactory.buildOrganismHost();
            organismHost.setOrganism(organism);
            List<DbReferenceType> dbReferenceTypes = xmlOrganismHost.getDbReference();
            for (DbReferenceType xmlDBref : dbReferenceTypes) {
                NcbiTaxonomyId taxID = this.uniProtFactory.buildNcbiTaxonomyId(xmlDBref.getId());
                taxID.setEvidenceIds(this.evidencesHandler.parseEvidenceIDs(xmlDBref.getEvidence()));
                organismHost.setNcbiTaxonomyId(taxID);
            }
            organismHosts.add(organismHost);
        }
        return organismHosts;
    }

    @Override
    public List<OrganismType> toXmlBinding(List<OrganismHost> organismHosts) {
        ArrayList<OrganismType> organisms = new ArrayList<OrganismType>();
        for (OrganismHost organismHost : organismHosts) {
            List<Integer> evs;
            OrganismType organismXML = this.objectFactory.createOrganismType();
            this.nameUpdater.toXmlBinding(organismHost.getOrganism(), organismXML);
            DbReferenceType dbReferenceXML = this.objectFactory.createDbReferenceType();
            dbReferenceXML.setType("NCBI Taxonomy");
            dbReferenceXML.setId(organismHost.getNcbiTaxonomyId().getValue());
            if (!organismHost.getNcbiTaxonomyId().getEvidenceIds().isEmpty() && !(evs = this.evidencesHandler.writeEvidenceIDs(organismHost.getNcbiTaxonomyId().getEvidenceIds())).isEmpty()) {
                dbReferenceXML.getEvidence().addAll(evs);
            }
            organismXML.getDbReference().add(dbReferenceXML);
            organisms.add(organismXML);
        }
        return organisms;
    }
}

