/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.keyword;

import java.util.List;
import uk.ac.ebi.kraken.interfaces.factories.UniProtFactory;
import uk.ac.ebi.kraken.interfaces.keywordlist.KeyListProxy;
import uk.ac.ebi.kraken.interfaces.keywordlist.KeywordNotRecognizedException;
import uk.ac.ebi.kraken.interfaces.uniprot.Keyword;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.KeywordType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class KeywordHandler
implements GenericHandler<Keyword, KeywordType> {
    private final ObjectFactory xmlUniprotFactory;
    private final UniProtFactory uniprotFactory;
    private final EvidenceReferenceHandler evidenceReferenceHandler;
    private final KeyListProxy keyListProxy;

    public KeywordHandler(KeyListProxy keyListProxy, EvidenceReferenceHandler evidenceReferenceHandler) {
        this(DefaultUniProtFactory.getInstance(), new ObjectFactory(), keyListProxy, evidenceReferenceHandler);
    }

    public KeywordHandler(KeyListProxy keyListProxy) {
        this(DefaultUniProtFactory.getInstance(), new ObjectFactory(), keyListProxy, null);
    }

    public KeywordHandler(UniProtFactory uniprotFactory, ObjectFactory xmlUniprotFactory, KeyListProxy keyListProxy, EvidenceReferenceHandler evidenceReferenceHandler) {
        this.uniprotFactory = uniprotFactory;
        this.xmlUniprotFactory = xmlUniprotFactory;
        this.keyListProxy = keyListProxy;
        this.evidenceReferenceHandler = evidenceReferenceHandler;
    }

    @Override
    public Keyword fromXmlBinding(KeywordType keywordType) {
        String keywordValue = keywordType.getValue();
        Keyword keyword = this.uniprotFactory.buildKeyword(keywordValue);
        if (!keywordType.getEvidence().isEmpty()) {
            keyword.setEvidenceIds(this.evidenceReferenceHandler.parseEvidenceIDs(keywordType.getEvidence()));
        }
        return keyword;
    }

    @Override
    public KeywordType toXmlBinding(Keyword keyword) {
        List<Integer> ev;
        KeywordType xmlKeyword = this.xmlUniprotFactory.createKeywordType();
        String value = keyword.getValue();
        xmlKeyword.setValue(value);
        try {
            xmlKeyword.setId(this.keyListProxy.getIdForName(value));
        }
        catch (KeywordNotRecognizedException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (!keyword.getEvidenceIds().isEmpty() && !(ev = this.evidenceReferenceHandler.writeEvidenceIDs(keyword.getEvidenceIds())).isEmpty()) {
            xmlKeyword.getEvidence().addAll(ev);
        }
        return xmlKeyword;
    }
}

