/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.feature;

import java.util.List;
import java.util.StringTokenizer;
import uk.ac.ebi.kraken.interfaces.uniprot.features.VarSeqFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.VarsplicIsoform;
import uk.ac.ebi.kraken.model.factories.DefaultFeatureFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.FeatureType;
import uk.ac.ebi.kraken.xml.uniprot.feature.AltSequenceHandlerStrategy;
import uk.ac.ebi.kraken.xml.uniprot.feature.FeatureHandlerStrategy;
import uk.ac.ebi.kraken.xml.uniprot.feature.FeatureIdHandlerStrategy;
import uk.ac.ebi.kraken.xml.uniprot.feature.LocationHandlerStrategy;

public class VarSeqHandlerStrategy
implements FeatureHandlerStrategy<VarSeqFeature> {
    private final LocationHandlerStrategy locationHandlerStrategy;
    private final FeatureIdHandlerStrategy featureIdHandlerStrategy;
    private final AltSequenceHandlerStrategy altSequenceHandlerStrategy;

    public VarSeqHandlerStrategy(LocationHandlerStrategy locationHandlerStrategy, FeatureIdHandlerStrategy featureIdHandlerStrategy, AltSequenceHandlerStrategy altSequenceHandlerStrategy) {
        this.locationHandlerStrategy = locationHandlerStrategy;
        this.featureIdHandlerStrategy = featureIdHandlerStrategy;
        this.altSequenceHandlerStrategy = altSequenceHandlerStrategy;
    }

    @Override
    public void featureFromXmlBinding(VarSeqFeature feature, FeatureType xmlFeature) {
        this.varSeqFromXmlBinding(feature, xmlFeature);
    }

    void varSeqFromXmlBinding(VarSeqFeature feature, FeatureType xmlFeature) {
        this.locationHandlerStrategy.featureFromXmlBinding(feature, xmlFeature);
        this.featureIdHandlerStrategy.featureFromXmlBinding(feature, xmlFeature);
        this.altSequenceHandlerStrategy.featureFromXmlBinding(feature, xmlFeature);
        String description = xmlFeature.getDescription();
        if (description != null) {
            this.consumeVarSplicFeature(feature, description);
        }
    }

    @Override
    public void featureToXmlBinding(VarSeqFeature feature, FeatureType xmlFeature) {
        this.varSeqToXmlBinding(feature, xmlFeature);
    }

    void varSeqToXmlBinding(VarSeqFeature feature, FeatureType xmlFeature) {
        this.locationHandlerStrategy.featureToXmlBinding(feature, xmlFeature);
        this.featureIdHandlerStrategy.featureToXmlBinding(feature, xmlFeature);
        this.altSequenceHandlerStrategy.featureToXmlBinding(feature, xmlFeature);
        String description = this.composeVarsplicAnnotation(feature);
        xmlFeature.setDescription(description);
    }

    private String composeVarsplicAnnotation(VarSeqFeature feature) {
        StringBuilder sb = new StringBuilder();
        sb.append("In ");
        List<VarsplicIsoform> varsplicIsoforms = feature.getVarsplicIsoforms();
        boolean isFirst = true;
        for (int i = 0; i < varsplicIsoforms.size(); ++i) {
            VarsplicIsoform varsplicIsoform = varsplicIsoforms.get(i);
            if (!isFirst) {
                if (i == varsplicIsoforms.size() - 1) {
                    sb.append(" and ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("isoform ");
            sb.append(varsplicIsoform.getValue());
            isFirst = false;
        }
        sb.append(".");
        return sb.toString();
    }

    private void consumeVarSplicFeature(VarSeqFeature feature, String value) {
        if (value.length() < 3) {
            return;
        }
        String reportString = value.substring(3, value.length() - 1);
        reportString = reportString.replaceAll("\n", "");
        reportString = reportString.replaceAll(" and ", ",");
        reportString = reportString.replaceAll("isoform ", "");
        StringTokenizer st = new StringTokenizer(reportString, ",");
        while (st.hasMoreTokens()) {
            String isoform = st.nextToken().trim();
            feature.getVarsplicIsoforms().add(DefaultFeatureFactory.getInstance().buildVarsplicIsoform(isoform));
        }
    }
}

