/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.feature;

import uk.ac.ebi.kraken.interfaces.factories.FeatureFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.features.CarbohydFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.ConflictFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.Feature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureType;
import uk.ac.ebi.kraken.interfaces.uniprot.features.MutagenFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.VarSeqFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.VariantFeature;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.uniprot.citations.CitationReferenceHandler;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;
import uk.ac.ebi.kraken.xml.uniprot.feature.AltSequenceHandlerStrategy;
import uk.ac.ebi.kraken.xml.uniprot.feature.CarbohydHandlerStrategy;
import uk.ac.ebi.kraken.xml.uniprot.feature.CommonFeatureHandlerStrategy;
import uk.ac.ebi.kraken.xml.uniprot.feature.ConflictHandlerStrategy;
import uk.ac.ebi.kraken.xml.uniprot.feature.DescriptionHandlerStrategy;
import uk.ac.ebi.kraken.xml.uniprot.feature.FeatureHandler;
import uk.ac.ebi.kraken.xml.uniprot.feature.FeatureIdHandlerStrategy;
import uk.ac.ebi.kraken.xml.uniprot.feature.LocationHandlerStrategy;
import uk.ac.ebi.kraken.xml.uniprot.feature.MutagenHandlerStrategy;
import uk.ac.ebi.kraken.xml.uniprot.feature.StatusHandlerStrategy;
import uk.ac.ebi.kraken.xml.uniprot.feature.VarSeqHandlerStrategy;
import uk.ac.ebi.kraken.xml.uniprot.feature.VariantHandlerStrategy;

public class FeatureHandlerFactory {
    private final FeatureFactory featureFactory = DefaultUniProtFactory.getFeatureFactory();
    private final ObjectFactory xmlFactory = new ObjectFactory();
    private final AltSequenceHandlerStrategy altSequenceHandlerStrategy = new AltSequenceHandlerStrategy(this.featureFactory);
    private final DescriptionHandlerStrategy descriptionHandlerStrategy = new DescriptionHandlerStrategy(this.featureFactory);
    private final FeatureIdHandlerStrategy featureIdHandlerStrategy = new FeatureIdHandlerStrategy(this.featureFactory);
    private final LocationHandlerStrategy locationHandlerStrategy = new LocationHandlerStrategy(this.featureFactory, this.xmlFactory);
    private final StatusHandlerStrategy statusHandlerStrategy = new StatusHandlerStrategy();
    private final MutagenHandlerStrategy mutagenHandlerStrategy = new MutagenHandlerStrategy(this.altSequenceHandlerStrategy, this.locationHandlerStrategy);
    private final VariantHandlerStrategy variantHandlerStrategy = new VariantHandlerStrategy(this.locationHandlerStrategy, this.featureIdHandlerStrategy, this.altSequenceHandlerStrategy);
    private final VarSeqHandlerStrategy varSeqHandlerStrategy = new VarSeqHandlerStrategy(this.locationHandlerStrategy, this.featureIdHandlerStrategy, this.altSequenceHandlerStrategy);

    public static FeatureHandlerFactory getInstance() {
        return Singleton.INSTANCE.getSingleton();
    }

    private FeatureHandlerFactory() {
    }

    public <T extends Feature> FeatureHandler<T> createFeatureHandler(FeatureType featureType, EvidenceReferenceHandler evidenceReferenceHandler, CitationReferenceHandler citationReferenceHandler) {
        switch (featureType) {
            case CARBOHYD: {
                CarbohydHandlerStrategy carbohydHandlerStrategy = new CarbohydHandlerStrategy(this.featureFactory, this.xmlFactory, this.locationHandlerStrategy, this.statusHandlerStrategy, this.descriptionHandlerStrategy, this.featureIdHandlerStrategy);
                return new FeatureHandler<CarbohydFeature>(carbohydHandlerStrategy, evidenceReferenceHandler);
            }
            case CONFLICT: {
                ConflictHandlerStrategy conflictHandlerStrategy = new ConflictHandlerStrategy(this.locationHandlerStrategy, this.altSequenceHandlerStrategy, citationReferenceHandler);
                return new FeatureHandler<ConflictFeature>(conflictHandlerStrategy, evidenceReferenceHandler);
            }
            case MUTAGEN: {
                return new FeatureHandler<MutagenFeature>(this.mutagenHandlerStrategy, evidenceReferenceHandler);
            }
            case VARIANT: {
                return new FeatureHandler<VariantFeature>(this.variantHandlerStrategy, evidenceReferenceHandler);
            }
            case VAR_SEQ: {
                return new FeatureHandler<VarSeqFeature>(this.varSeqHandlerStrategy, evidenceReferenceHandler);
            }
        }
        CommonFeatureHandlerStrategy commonFeatureHandlerStrategy = new CommonFeatureHandlerStrategy();
        return new FeatureHandler(commonFeatureHandlerStrategy, evidenceReferenceHandler);
    }

    public <T extends Feature> FeatureHandler<T> createFeatureHandler(FeatureType featureType, EvidenceReferenceHandler evidenceReferenceHandler) {
        return this.createFeatureHandler(featureType, evidenceReferenceHandler, new CitationReferenceHandler());
    }

    public <T extends Feature> FeatureHandler<T> createFeatureHandler(T feature, EvidenceReferenceHandler evidenceReferenceHandler) {
        return this.createFeatureHandler(feature.getType(), evidenceReferenceHandler, new CitationReferenceHandler());
    }

    private static enum Singleton {
        INSTANCE;

        private static final FeatureHandlerFactory factory;

        public FeatureHandlerFactory getSingleton() {
            return factory;
        }

        static {
            factory = new FeatureHandlerFactory();
        }
    }
}

