/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.description;

import java.util.List;
import uk.ac.ebi.kraken.interfaces.factories.UniProtFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Name;
import uk.ac.ebi.kraken.interfaces.uniprot.description.NameType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.EvidencedStringType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ProteinType;
import uk.ac.ebi.kraken.xml.uniprot.description.EcNumberHandler;
import uk.ac.ebi.kraken.xml.uniprot.description.GenericNameHandler;
import uk.ac.ebi.kraken.xml.uniprot.description.GenericXmlName;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class SubmittedNameHandler
extends GenericNameHandler<ProteinType.SubmittedName, Name> {
    public SubmittedNameHandler(ObjectFactory objectFactory, UniProtFactory factory, EvidenceReferenceHandler evidenceReferenceHandler, EcNumberHandler ecNumberHandler) {
        super(objectFactory, factory, evidenceReferenceHandler, ecNumberHandler);
    }

    @Override
    public ProteinType.SubmittedName toXmlName(Name name) {
        GenericXmlName xmlName = this.populateXmlName(name);
        return this.convertGenericToSubmittedName(xmlName);
    }

    @Override
    public Name fromXmlName(ProteinType.SubmittedName subXmlName) {
        GenericXmlName xmlName = this.convertSubmittedToGenericName(subXmlName);
        if (xmlName != null) {
            Name subName = this.populateName(xmlName);
            subName.setNameType(NameType.SUBNAME);
            return subName;
        }
        return null;
    }

    private ProteinType.SubmittedName convertGenericToSubmittedName(GenericXmlName xmlName) {
        if (xmlName != null) {
            List<EvidencedStringType> ecNumberList;
            boolean touched = false;
            ProteinType.SubmittedName subName = this.objectFactory.createProteinTypeSubmittedName();
            EvidencedStringType fullName = xmlName.getFullName();
            if (fullName != null) {
                subName.setFullName(fullName);
                touched = true;
            }
            if (!(ecNumberList = xmlName.getEcNumberList()).isEmpty()) {
                subName.getEcNumber().addAll(ecNumberList);
                touched = true;
            }
            return touched ? subName : null;
        }
        return null;
    }

    private GenericXmlName convertSubmittedToGenericName(ProteinType.SubmittedName subXmlName) {
        if (subXmlName != null) {
            List<EvidencedStringType> ecNumberList;
            boolean touched = false;
            GenericXmlName genericXmlName = new GenericXmlName();
            EvidencedStringType fullName = subXmlName.getFullName();
            if (fullName != null) {
                genericXmlName.setFullName(fullName);
                touched = true;
            }
            if (!(ecNumberList = subXmlName.getEcNumber()).isEmpty()) {
                genericXmlName.setEcNumberList(ecNumberList);
                touched = true;
            }
            return touched ? genericXmlName : null;
        }
        return null;
    }
}

