/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.comment.humdiseaselist;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.kraken.xml.uniprot.comment.humdiseaselist.DiseaseIdListReader;

public class DiseaseIdListFileReader
implements DiseaseIdListReader {
    private static final String IDENTIFIER_TOKEN_PREFIX = "ID   ";
    private static final String ACCESSION_TOKEN_PREFIX = "AC   ";
    private static final String END_DISEASE_DEFINITION = "//";
    private Map<String, String> idMappings;
    private final String filePath;
    private static final Logger LOG = LoggerFactory.getLogger(DiseaseIdListFileReader.class);

    public DiseaseIdListFileReader(String filePath) {
        this.filePath = filePath;
    }

    @Override
    public synchronized Map<String, String> readIds() {
        if (this.idMappings == null) {
            this.idMappings = this.doReadIds();
        }
        return this.idMappings;
    }

    public Map<String, String> doReadIds() {
        String accession = null;
        String identifier = null;
        ConcurrentHashMap<String, String> diseaseNameToId = new ConcurrentHashMap<String, String>();
        try (BufferedReader reader = this.getBufferedReader();){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith(IDENTIFIER_TOKEN_PREFIX)) {
                    identifier = this.parseIdentifier(line);
                }
                if (line.startsWith(ACCESSION_TOKEN_PREFIX)) {
                    accession = this.parseAccession(line);
                }
                if (!line.equals(END_DISEASE_DEFINITION)) continue;
                diseaseNameToId.put(identifier, accession);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read file: " + this.filePath + " " + e.getMessage(), e);
        }
        return diseaseNameToId;
    }

    private BufferedReader getBufferedReader() {
        try {
            URL url = new URL(this.filePath);
            URLConnection con = url.openConnection(Proxy.NO_PROXY);
            InputStream is = con.getInputStream();
            return new BufferedReader(new InputStreamReader(is));
        }
        catch (IOException e) {
            LOG.debug("Failed to create inputStream: " + this.filePath);
            try {
                LOG.debug("Use file directly: " + this.filePath);
                return new BufferedReader(new FileReader(this.filePath));
            }
            catch (IOException e2) {
                throw new RuntimeException("Cannot read file: " + this.filePath + " " + e2.getMessage(), e2);
            }
        }
    }

    public String parseIdentifier(String identifierLineContent) {
        return identifierLineContent.substring(identifierLineContent.indexOf(IDENTIFIER_TOKEN_PREFIX) + IDENTIFIER_TOKEN_PREFIX.length(), identifierLineContent.lastIndexOf(46));
    }

    public String parseAccession(String accessionLineContent) {
        return accessionLineContent.substring(accessionLineContent.indexOf(ACCESSION_TOKEN_PREFIX) + ACCESSION_TOKEN_PREFIX.length());
    }
}

