/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.comment;

import com.google.common.base.Strings;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.factories.CommentFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.WebResourceComment;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.EvidencedStringType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.MoleculeType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class WebResourceHandler
implements GenericHandler<WebResourceComment, uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType> {
    private final CommentFactory commentFactory;
    private final ObjectFactory objectFactory;
    private final EvidenceReferenceHandler evidenceReferenceHandler;

    public WebResourceHandler(CommentFactory commentFactory, ObjectFactory objectFactory, EvidenceReferenceHandler referenceHandler) {
        this.commentFactory = commentFactory;
        this.objectFactory = objectFactory;
        this.evidenceReferenceHandler = referenceHandler;
    }

    @Override
    public WebResourceComment fromXmlBinding(uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType xmlObject) {
        if (xmlObject == null) {
            return null;
        }
        WebResourceComment databaseComment = (WebResourceComment)this.commentFactory.buildComment(CommentType.WEBRESOURCE);
        if (xmlObject.getMolecule() != null) {
            databaseComment.setMolecule(xmlObject.getMolecule().getValue());
        }
        if (xmlObject.getName() != null) {
            databaseComment.setDatabaseName(this.commentFactory.buildDatabaseName(xmlObject.getName()));
        }
        List<CommentType.Link> listLinks = xmlObject.getLink();
        for (CommentType.Link linkXML : listLinks) {
            String link = linkXML.getUri();
            if (link.toLowerCase().startsWith("ftp")) {
                databaseComment.setDatabaseFTP(this.commentFactory.buildDatabaseFTP(linkXML.getUri()));
                continue;
            }
            databaseComment.setDatabaseURL(this.commentFactory.buildDatabaseURL(linkXML.getUri()));
        }
        if (!xmlObject.getText().isEmpty()) {
            String text = xmlObject.getText().get(0).getValue();
            databaseComment.setDatabaseNote(this.commentFactory.buildDatabaseNote(text));
        }
        if (!xmlObject.getEvidence().isEmpty()) {
            databaseComment.getEvidenceIds().addAll(this.evidenceReferenceHandler.parseEvidenceIDs(xmlObject.getEvidence()));
        }
        return databaseComment;
    }

    @Override
    public uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType toXmlBinding(WebResourceComment object) {
        CommentType.Link xmlLink;
        if (object == null) {
            return null;
        }
        uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType commentType = this.objectFactory.createCommentType();
        commentType.setType("online information");
        if (!Strings.isNullOrEmpty((String)object.getMolecule())) {
            MoleculeType mol = this.objectFactory.createMoleculeType();
            mol.setValue(object.getMolecule());
            commentType.setMolecule(mol);
        }
        if (object.hasDatabaseName()) {
            commentType.setName(object.getDatabaseName().getValue());
        }
        if (object.hasDatabaseFTP()) {
            xmlLink = this.objectFactory.createCommentTypeLink();
            xmlLink.setUri(object.getDatabaseFTP().getValue());
            commentType.getLink().add(xmlLink);
        }
        if (object.hasDatabaseURL()) {
            xmlLink = this.objectFactory.createCommentTypeLink();
            xmlLink.setUri(object.getDatabaseURL().getValue());
            commentType.getLink().add(xmlLink);
        }
        if (object.hasDatabaseNote()) {
            EvidencedStringType evidencedStringType = this.objectFactory.createEvidencedStringType();
            evidencedStringType.setValue(object.getDatabaseNote().getValue());
            commentType.getText().add(evidencedStringType);
        }
        return commentType;
    }
}

