/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.comment;

import java.math.BigInteger;
import uk.ac.ebi.kraken.interfaces.factories.CommentFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Position;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.LocationType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.PositionType;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class RnaEditingPositionsHandler
implements GenericHandler<Position, LocationType> {
    private final CommentFactory commentFactory;
    private final ObjectFactory objectFactory;
    private final EvidenceReferenceHandler evRefHandler;

    public RnaEditingPositionsHandler(CommentFactory commentFactory, ObjectFactory objectFactory, EvidenceReferenceHandler evRefHandler) {
        this.commentFactory = commentFactory;
        this.objectFactory = objectFactory;
        this.evRefHandler = evRefHandler;
    }

    @Override
    public Position fromXmlBinding(LocationType locationType) {
        if (locationType != null && locationType.getPosition() != null) {
            Position position = this.commentFactory.buildRnaEditingPosition();
            position.setPosition(locationType.getPosition().getPosition().toString().trim());
            if (!locationType.getPosition().getEvidence().isEmpty()) {
                position.getEvidenceIds().addAll(this.evRefHandler.parseEvidenceIDs(locationType.getPosition().getEvidence()));
            }
            return position;
        }
        return null;
    }

    @Override
    public LocationType toXmlBinding(Position position) {
        if (position != null && !position.getPosition().isEmpty()) {
            LocationType locationType = this.objectFactory.createLocationType();
            PositionType positionType = this.objectFactory.createPositionType();
            String pos = position.getPosition().trim();
            if (!Character.isDigit(pos.charAt(0))) {
                return null;
            }
            positionType.setPosition(new BigInteger(pos));
            positionType.setStatus(null);
            if (!position.getEvidenceIds().isEmpty()) {
                positionType.getEvidence().addAll(this.evRefHandler.writeEvidenceIDs(position.getEvidenceIds()));
            }
            locationType.setPosition(positionType);
            return locationType;
        }
        return null;
    }
}

