/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.citations.common;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.factories.CitationNewFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Author;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.CitationType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.NameListType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.PersonType;
import uk.ac.ebi.kraken.xml.uniprot.citations.CitationItemFactory;
import uk.ac.ebi.kraken.xml.uniprot.citations.common.AuthorAndConsortiumHandler;

public class AuthorsListHandler
implements AuthorAndConsortiumHandler<Author> {
    private final ObjectFactory objectFactory;
    private final GenericHandler<Author, String> authorHandler;

    public AuthorsListHandler(CitationNewFactory citationFactory, ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
        CitationItemFactory itemFactory = new CitationItemFactory();
        itemFactory.setCitationFactory(citationFactory);
        this.authorHandler = itemFactory.buildAuthorHandler();
    }

    @Override
    public List<Author> fromJAXB(CitationType citationXML) {
        if (citationXML == null || citationXML.getAuthorList() == null) {
            return null;
        }
        NameListType authorListXML = citationXML.getAuthorList();
        List<Object> listPersonOrConsortium = authorListXML.getConsortiumOrPerson();
        ArrayList<Author> authorList = new ArrayList<Author>();
        for (Object o : listPersonOrConsortium) {
            if (!(o instanceof PersonType)) continue;
            PersonType person = (PersonType)o;
            authorList.add(this.authorHandler.fromXmlBinding(person.getName()));
        }
        return authorList;
    }

    @Override
    public NameListType toJAXB(Citation citation) {
        if (citation == null) {
            return null;
        }
        if (citation.getAuthors() != null && !citation.getAuthors().isEmpty()) {
            ArrayList<PersonType> listPersonOrConsortium = new ArrayList<PersonType>();
            NameListType authorListXML = this.objectFactory.createNameListType();
            List<Author> listAuthors = citation.getAuthors();
            for (Author author : listAuthors) {
                listPersonOrConsortium.add(this.getPersonType(author));
            }
            if (!listPersonOrConsortium.isEmpty()) {
                authorListXML.getConsortiumOrPerson().addAll(listPersonOrConsortium);
            }
            return authorListXML;
        }
        return null;
    }

    private PersonType getPersonType(Author author) {
        PersonType personXML = this.objectFactory.createPersonType();
        personXML.setName(this.authorHandler.toXmlBinding(author));
        return personXML;
    }
}

