/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.citations;

import uk.ac.ebi.kraken.interfaces.factories.CitationNewFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.JournalArticle;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.JournalName;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Page;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.PublicationDate;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Volume;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.CitationType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ReferenceType;
import uk.ac.ebi.kraken.xml.uniprot.GenericUpdater;
import uk.ac.ebi.kraken.xml.uniprot.citations.CitationItemFactory;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class JournalArticleHandler
implements GenericHandler<JournalArticle, ReferenceType> {
    private final CitationNewFactory citationFactory;
    private final ObjectFactory objectFactory;
    private final GenericHandler<JournalName, String> journalNameHandler;
    private final GenericHandler<Page, String> pageHandler;
    private final GenericHandler<Volume, String> volumeHandler;
    private final GenericHandler<PublicationDate, String> publicationDateHandler;
    private final GenericUpdater<Citation, ReferenceType> commonReferenceUpdater;

    public JournalArticleHandler(ObjectFactory objectFactory, CitationNewFactory citationFactory, EvidenceReferenceHandler evidenceReferenceHandler) {
        this.citationFactory = citationFactory;
        this.objectFactory = objectFactory;
        CitationItemFactory itemFactory = new CitationItemFactory();
        itemFactory.setCitationFactory(citationFactory);
        itemFactory.setObjectFactory(objectFactory);
        itemFactory.setReferenceHandler(evidenceReferenceHandler);
        this.journalNameHandler = itemFactory.buildJournalNameHandler();
        this.pageHandler = itemFactory.buildPageHandler();
        this.volumeHandler = itemFactory.buildVolumeHandler();
        this.commonReferenceUpdater = itemFactory.buildCommonReferenceUpdater();
        this.publicationDateHandler = itemFactory.buildPublicationDateHandler();
    }

    @Override
    public JournalArticle fromXmlBinding(ReferenceType referenceXML) {
        if (referenceXML != null) {
            PublicationDate publicationDate;
            Volume volume;
            Page last;
            Page first;
            JournalArticle citation = this.citationFactory.buildJournalArticle();
            CitationType citationXML = referenceXML.getCitation();
            if (citationXML == null) {
                return null;
            }
            JournalName journalName = this.journalNameHandler.fromXmlBinding(citationXML.getName());
            if (journalName != null) {
                citation.setJournalName(journalName);
            }
            if ((first = this.pageHandler.fromXmlBinding(citationXML.getFirst())) != null) {
                citation.setFirstPage(first);
            }
            if ((last = this.pageHandler.fromXmlBinding(citationXML.getLast())) != null) {
                citation.setLastPage(last);
            }
            if ((volume = this.volumeHandler.fromXmlBinding(citationXML.getVolume())) != null) {
                citation.setVolume(volume);
            }
            if ((publicationDate = this.publicationDateHandler.fromXmlBinding(citationXML.getDate())) != null) {
                citation.setPublicationDate(publicationDate);
            }
            this.commonReferenceUpdater.fromXmlBinding(citation, referenceXML);
            return citation;
        }
        return null;
    }

    @Override
    public ReferenceType toXmlBinding(JournalArticle citation) {
        if (citation != null) {
            ReferenceType referenceXML = this.objectFactory.createReferenceType();
            CitationType citationXML = this.objectFactory.createCitationType();
            referenceXML.setCitation(citationXML);
            citationXML.setType("journal article");
            citationXML.setName(this.journalNameHandler.toXmlBinding(citation.getJournalName()));
            citationXML.setFirst(this.pageHandler.toXmlBinding(citation.getFirstPage()));
            citationXML.setLast(this.pageHandler.toXmlBinding(citation.getLastPage()));
            citationXML.setVolume(this.volumeHandler.toXmlBinding(citation.getVolume()));
            citationXML.setDate(this.publicationDateHandler.toXmlBinding(citation.getPublicationDate()));
            this.commonReferenceUpdater.toXmlBinding(referenceXML, citation);
            return referenceXML;
        }
        return null;
    }
}

