/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.citations;

import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Book;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.CitationTypeEnum;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.ElectronicArticle;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.JournalArticle;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Patent;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Submission;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Thesis;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.UnpublishedObservations;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ReferenceType;
import uk.ac.ebi.kraken.xml.uniprot.citations.BookHandler;
import uk.ac.ebi.kraken.xml.uniprot.citations.CitationReferenceHandler;
import uk.ac.ebi.kraken.xml.uniprot.citations.ElectronicArticleHandler;
import uk.ac.ebi.kraken.xml.uniprot.citations.JournalArticleHandler;
import uk.ac.ebi.kraken.xml.uniprot.citations.PatentHandler;
import uk.ac.ebi.kraken.xml.uniprot.citations.SubmissionHandler;
import uk.ac.ebi.kraken.xml.uniprot.citations.ThesisHandler;
import uk.ac.ebi.kraken.xml.uniprot.citations.UnpublishedObservationsHandler;

public class CitationHandler
implements GenericHandler<Citation, ReferenceType> {
    private JournalArticleHandler journalArticleHandler;
    private ElectronicArticleHandler electronicArticleHandler;
    private PatentHandler patentHandler;
    private BookHandler bookHandler;
    private SubmissionHandler submissionHandler;
    private ThesisHandler thesisHandler;
    private UnpublishedObservationsHandler unpublishedObservationsHandler;
    private CitationReferenceHandler citationReferenceHandler;

    public void setJournalArticleHandler(JournalArticleHandler journalArticleHandler) {
        this.journalArticleHandler = journalArticleHandler;
    }

    public void setElectronicArticleHandler(ElectronicArticleHandler electronicArticleHandler) {
        this.electronicArticleHandler = electronicArticleHandler;
    }

    public void setPatentHandler(PatentHandler patentHandler) {
        this.patentHandler = patentHandler;
    }

    public void setBookHandler(BookHandler bookHandler) {
        this.bookHandler = bookHandler;
    }

    public void setSubmissionHandler(SubmissionHandler submissionHandler) {
        this.submissionHandler = submissionHandler;
    }

    public void setThesisHandler(ThesisHandler thesisHandler) {
        this.thesisHandler = thesisHandler;
    }

    public void setUnpublishedObservationsHandler(UnpublishedObservationsHandler unpublishedObservationsHandler) {
        this.unpublishedObservationsHandler = unpublishedObservationsHandler;
    }

    @Override
    public Citation fromXmlBinding(ReferenceType xmlObject) {
        Citation citation = null;
        if (xmlObject.getCitation().getType().equals(CitationTypeEnum.JOURNAL_ARTICLE.getValue())) {
            citation = this.journalArticleHandler.fromXmlBinding(xmlObject);
        } else if (xmlObject.getCitation().getType().equals(CitationTypeEnum.BOOK.getValue())) {
            citation = this.bookHandler.fromXmlBinding(xmlObject);
        } else if (xmlObject.getCitation().getType().equals(CitationTypeEnum.ELECTRONIC_ARTICLE.getValue())) {
            citation = this.electronicArticleHandler.fromXmlBinding(xmlObject);
        } else if (xmlObject.getCitation().getType().equals(CitationTypeEnum.PATENT.getValue())) {
            citation = this.patentHandler.fromXmlBinding(xmlObject);
        } else if (xmlObject.getCitation().getType().equals(CitationTypeEnum.SUBMISSION.getValue())) {
            citation = this.submissionHandler.fromXmlBinding(xmlObject);
        } else if (xmlObject.getCitation().getType().equals(CitationTypeEnum.THESIS.getValue())) {
            citation = this.thesisHandler.fromXmlBinding(xmlObject);
        } else if (xmlObject.getCitation().getType().equals(CitationTypeEnum.UNPUBLISHED_OBSERVATIONS.getValue())) {
            citation = this.unpublishedObservationsHandler.fromXmlBinding(xmlObject);
        }
        return citation;
    }

    @Override
    public ReferenceType toXmlBinding(Citation citation) {
        if (citation.getCitationType() == CitationTypeEnum.JOURNAL_ARTICLE) {
            ReferenceType xmlObject = this.journalArticleHandler.toXmlBinding((JournalArticle)citation);
            return xmlObject;
        }
        if (citation.getCitationType() == CitationTypeEnum.BOOK) {
            ReferenceType xmlObject = this.bookHandler.toXmlBinding((Book)citation);
            return xmlObject;
        }
        if (citation.getCitationType() == CitationTypeEnum.ELECTRONIC_ARTICLE) {
            ReferenceType xmlObject = this.electronicArticleHandler.toXmlBinding((ElectronicArticle)citation);
            return xmlObject;
        }
        if (citation.getCitationType() == CitationTypeEnum.PATENT) {
            ReferenceType xmlObject = this.patentHandler.toXmlBinding((Patent)citation);
            return xmlObject;
        }
        if (citation.getCitationType() == CitationTypeEnum.SUBMISSION) {
            ReferenceType xmlObject = this.submissionHandler.toXmlBinding((Submission)citation);
            return xmlObject;
        }
        if (citation.getCitationType() == CitationTypeEnum.THESIS) {
            ReferenceType xmlObject = this.thesisHandler.toXmlBinding((Thesis)citation);
            return xmlObject;
        }
        if (citation.getCitationType() == CitationTypeEnum.UNPUBLISHED_OBSERVATIONS) {
            ReferenceType xmlObject = this.unpublishedObservationsHandler.toXmlBinding((UnpublishedObservations)citation);
            return xmlObject;
        }
        return null;
    }

    public void setCitationReferenceHandler(CitationReferenceHandler citationReferenceHandler) {
        this.citationReferenceHandler = citationReferenceHandler;
    }

    public void addIndex(int keyVal) {
        this.citationReferenceHandler.getIdForCitationIndex(keyVal);
    }
}

