/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.citations;

import java.util.List;
import uk.ac.ebi.kraken.interfaces.factories.CitationNewFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Book;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.BookName;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.City;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Editor;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Page;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Publisher;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Volume;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.CitationType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.NameListType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.PersonType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ReferenceType;
import uk.ac.ebi.kraken.xml.uniprot.GenericUpdater;
import uk.ac.ebi.kraken.xml.uniprot.citations.CitationItemFactory;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class BookHandler
implements GenericHandler<Book, ReferenceType> {
    private final ObjectFactory objectFactory;
    private final CitationNewFactory citationFactory;
    private final GenericHandler<City, String> cityHandler;
    private final GenericHandler<BookName, String> bookNameHandler;
    private final GenericHandler<Editor, String> editorsHandler;
    private final GenericHandler<Page, String> pageHandler;
    private final GenericHandler<Publisher, String> publisherHandler;
    private final GenericHandler<Volume, String> volumeHandler;
    private final GenericUpdater<Citation, ReferenceType> commonReferenceUpdater;

    public BookHandler(ObjectFactory objectFactory, CitationNewFactory citationFactory, EvidenceReferenceHandler evidenceReferenceHandler) {
        this.objectFactory = objectFactory;
        this.citationFactory = citationFactory;
        CitationItemFactory itemFactory = new CitationItemFactory();
        itemFactory.setCitationFactory(citationFactory);
        itemFactory.setObjectFactory(objectFactory);
        itemFactory.setReferenceHandler(evidenceReferenceHandler);
        this.cityHandler = itemFactory.buildCityHandler();
        this.bookNameHandler = new BookNameHandler(citationFactory);
        this.editorsHandler = itemFactory.buildEditorHandler();
        this.pageHandler = itemFactory.buildPageHandler();
        this.publisherHandler = itemFactory.buildPublisherHandler();
        this.volumeHandler = itemFactory.buildVolumeHandler();
        this.commonReferenceUpdater = itemFactory.buildCommonReferenceUpdater();
    }

    @Override
    public Book fromXmlBinding(ReferenceType referenceXML) {
        if (referenceXML != null) {
            Volume volume;
            Publisher publisher;
            Page first;
            BookName bookName;
            Book citation = this.citationFactory.buildBook();
            CitationType citationXML = referenceXML.getCitation();
            if (citationXML == null) {
                return null;
            }
            City city = this.cityHandler.fromXmlBinding(citationXML.getCity());
            if (city != null) {
                citation.setCity(city);
            }
            if ((bookName = this.bookNameHandler.fromXmlBinding(citationXML.getName())) != null) {
                citation.setBookName(bookName);
            }
            if (citationXML.getEditorList() != null) {
                List<Editor> editors = citation.getEditors();
                List<Object> listPersons = citationXML.getEditorList().getConsortiumOrPerson();
                for (Object person : listPersons) {
                    if (!(person instanceof PersonType)) continue;
                    editors.add(this.editorsHandler.fromXmlBinding(((PersonType)person).getName()));
                }
                citation.setEditors(editors);
            }
            if ((first = this.pageHandler.fromXmlBinding(citationXML.getFirst())) != null) {
                citation.setFirstPage(first);
            } else if (citationXML.getFirst() != null && !citationXML.getFirst().isEmpty()) {
                String bookNameS = bookName.getValue() + ", " + citationXML.getFirst();
                citation.setBookName(this.citationFactory.buildBookName(bookNameS));
            }
            Page last = this.pageHandler.fromXmlBinding(citationXML.getLast());
            if (last != null) {
                citation.setLastPage(last);
            }
            if ((publisher = this.publisherHandler.fromXmlBinding(citationXML.getPublisher())) != null) {
                citation.setPublisher(publisher);
            }
            if ((volume = this.volumeHandler.fromXmlBinding(citationXML.getVolume())) != null) {
                citation.setVolume(volume);
            }
            this.commonReferenceUpdater.fromXmlBinding(citation, referenceXML);
            return citation;
        }
        return null;
    }

    @Override
    public ReferenceType toXmlBinding(Book citation) {
        if (citation != null) {
            ReferenceType referenceXML = this.objectFactory.createReferenceType();
            CitationType citationXML = this.objectFactory.createCitationType();
            referenceXML.setCitation(citationXML);
            citationXML.setType("book");
            citationXML.setName(this.bookNameHandler.toXmlBinding(citation.getBookName()));
            citationXML.setCity(this.cityHandler.toXmlBinding(citation.getCity()));
            this.setEditorsToXml(citation, citationXML);
            citationXML.setVolume(this.volumeHandler.toXmlBinding(citation.getVolume()));
            this.setFirstPageToXml(citation, citationXML);
            citationXML.setLast(this.pageHandler.toXmlBinding(citation.getLastPage()));
            citationXML.setPublisher(this.publisherHandler.toXmlBinding(citation.getPublisher()));
            this.commonReferenceUpdater.toXmlBinding(referenceXML, citation);
            if (referenceXML.getCitation().getName() != null) {
                return referenceXML;
            }
        }
        return null;
    }

    private void setEditorsToXml(Book citation, CitationType citationXML) {
        if (citation.getEditors() != null && !citation.getEditors().isEmpty()) {
            List<Editor> listEditors = citation.getEditors();
            NameListType editorList = this.objectFactory.createNameListType();
            for (Editor editor : listEditors) {
                PersonType person = this.objectFactory.createPersonType();
                person.setName(this.editorsHandler.toXmlBinding(editor));
                editorList.getConsortiumOrPerson().add(person);
            }
            citationXML.setEditorList(editorList);
        }
    }

    private void setFirstPageToXml(Book citation, CitationType citationXML) {
        String first = this.pageHandler.toXmlBinding(citation.getFirstPage());
        if (first == null) {
            int abstractIndex = citation.getBookName().getValue().indexOf("abstract");
            if (abstractIndex > -1) {
                int nextSpace = citation.getBookName().getValue().indexOf(32, abstractIndex);
                if (nextSpace > -1) {
                    citationXML.setFirst(citation.getBookName().getValue().substring(abstractIndex, nextSpace));
                } else {
                    citationXML.setFirst(citation.getBookName().getValue().substring(abstractIndex));
                    String bookNameWithoutAbstract = this.bookNameHandler.toXmlBinding(citation.getBookName()).substring(0, abstractIndex - 1);
                    if (bookNameWithoutAbstract.endsWith(",")) {
                        bookNameWithoutAbstract = bookNameWithoutAbstract.substring(0, bookNameWithoutAbstract.length() - 1);
                    }
                    citationXML.setName(bookNameWithoutAbstract);
                }
            }
        } else {
            citationXML.setFirst(first);
        }
    }

    private class BookNameHandler
    implements GenericHandler<BookName, String> {
        private final CitationNewFactory citationFactory;

        BookNameHandler(CitationNewFactory citationFactory) {
            this.citationFactory = citationFactory;
        }

        @Override
        public BookName fromXmlBinding(String XML) {
            if (XML != null && XML.length() > 0) {
                return this.citationFactory.buildBookName(XML);
            }
            return null;
        }

        @Override
        public String toXmlBinding(BookName citation) {
            if (citation.getValue() != null && citation.getValue().trim().length() > 0) {
                return citation.getValue();
            }
            return null;
        }
    }
}

