/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.zip.GZIPInputStream;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.DatatypeConverterInterface;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.kraken.xml.common.KrakenDatatypeConverter;
import uk.ac.ebi.kraken.xml.common.XMLParserException;

public abstract class KrakenXMLIterator<T>
implements Iterable<T>,
Iterator<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KrakenXMLIterator.class);
    private final XMLInputFactory staxFactory = XMLInputFactory.newInstance();
    private XMLStreamReader staxStreamReader;
    protected T entry;
    protected Object xmlEntry;
    protected boolean quiet = false;
    protected Map<String, Exception> exceptionBucket;
    protected int maxEntriesInBucket = 1000;
    protected JAXBContext jaxbContext;
    protected Unmarshaller unmarshaller;

    public KrakenXMLIterator(URL url) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
        this.init(in);
    }

    public KrakenXMLIterator(File file) throws IOException {
        BufferedReader in = file.getName().endsWith(".gzip") || file.getName().endsWith(".gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(file))), 16384) : new BufferedReader(new FileReader(file), 16384);
        this.init(in);
    }

    public KrakenXMLIterator(InputStream inputStream) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
        this.init(in);
    }

    public KrakenXMLIterator(Reader reader) throws IOException {
        this.init(reader);
    }

    protected void init(Reader in) throws IOException {
        try {
            DatatypeConverter.setDatatypeConverter((DatatypeConverterInterface)new KrakenDatatypeConverter());
            this.configJAXBContext();
            this.unmarshaller = this.jaxbContext.createUnmarshaller();
            this.staxStreamReader = this.staxFactory.createXMLStreamReader(in);
            this.staxStreamReader.nextTag();
            this.staxStreamReader.nextTag();
            this.exceptionBucket = new HashMap<String, Exception>();
        }
        catch (JAXBException | XMLStreamException e) {
            LOGGER.error(e.getMessage());
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public boolean hasNext() {
        boolean answer = false;
        if (this.xmlEntry != null) {
            return true;
        }
        this.xmlEntry = this.getNextEntry();
        if (this.xmlEntry != null) {
            answer = true;
        }
        return answer;
    }

    @Override
    public T next() {
        T answer;
        if (this.xmlEntry != null) {
            answer = this.convertXMLEntry(this.xmlEntry);
        } else {
            this.xmlEntry = this.getNextEntry();
            if (this.xmlEntry != null) {
                answer = this.convertXMLEntry(this.xmlEntry);
            } else {
                throw new NoSuchElementException();
            }
        }
        this.xmlEntry = null;
        return answer;
    }

    private Object getNextEntry() {
        try {
            while (this.staxStreamReader.getEventType() == 1) {
                Object treeObject = this.unmarshaller.unmarshal(this.staxStreamReader);
                if (this.staxStreamReader.getEventType() == 4) {
                    this.staxStreamReader.next();
                }
                if (treeObject == null || !this.isXMLEntryType(treeObject)) continue;
                return treeObject;
            }
        }
        catch (JAXBException | XMLStreamException e) {
            if (!this.isQuiet()) {
                throw new XMLParserException("Parser error ", e);
            }
            LOGGER.error("Parser error " + e);
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    protected abstract String getNameSpace();

    protected abstract String getName();

    protected abstract T convertXMLEntry(Object var1);

    protected abstract boolean isXMLEntryType(Object var1);

    protected abstract void configJAXBContext();

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public Map<String, Exception> getExceptionBucket() {
        return this.exceptionBucket;
    }

    public void setExceptionBucket(Map<String, Exception> exceptionBucket) {
        this.exceptionBucket = exceptionBucket;
    }

    public int getMaxEntriesInBucket() {
        return this.maxEntriesInBucket;
    }

    public void setMaxEntriesInBucket(int maxEntriesInBucket) {
        this.maxEntriesInBucket = maxEntriesInBucket;
    }
}

