/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util.wrapper;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.ebi.kraken.util.wrapper.Rule;
import uk.ac.ebi.kraken.util.wrapper.SimpleTextHolder;

public abstract class WrapOnRegExRule
implements Rule<SimpleTextHolder> {
    public static final int DEFAULT_WRAP_LENGTH = 75;
    private int wrapLength = 75;
    private boolean wrapBeforeRegExMatch = false;
    private boolean wrapAtPreviousMatch = false;
    private boolean wrapOnRegExAlways = false;
    private int prefixLength = 0;

    public WrapOnRegExRule(int prefixLength) {
        this.prefixLength = prefixLength;
        this.wrapLength -= this.prefixLength;
    }

    public void setWrapBeforeRegExMatch(boolean value) {
        this.wrapBeforeRegExMatch = value;
    }

    public int getWrapLength() {
        return this.wrapLength;
    }

    public void setWrapLength(int wrapLength) {
        this.wrapLength = wrapLength;
    }

    public boolean isWrapAtPreviousMatch() {
        return this.wrapAtPreviousMatch;
    }

    public void setWrapAtPreviousMatch(boolean wrapAtPreviousMatch) {
        this.wrapAtPreviousMatch = wrapAtPreviousMatch;
    }

    public boolean isWrapOnRegExAlways() {
        return this.wrapOnRegExAlways;
    }

    public void setWrapOnRegExAlways(boolean wrapOnRegExAlways) {
        this.wrapOnRegExAlways = wrapOnRegExAlways;
    }

    public boolean isWrapBeforeRegExMatch() {
        return this.wrapBeforeRegExMatch;
    }

    @Override
    public boolean transform(SimpleTextHolder toTransform) {
        System.out.println(": " + this.prefixLength);
        StringBuilder newText = new StringBuilder();
        boolean used = false;
        for (String unbrokenLine : toTransform.getTextLines()) {
            int currLineEnd = 0;
            int matchIndexStart = 0;
            int matchIndexEnd = 0;
            int lastMatchIndexStart = 0;
            int lastMatchIndexEnd = 0;
            Matcher matcher = this.getRegex().matcher(unbrokenLine);
            while (matcher.find()) {
                lastMatchIndexStart = matchIndexStart;
                lastMatchIndexEnd = matchIndexEnd;
                matchIndexStart = matcher.start();
                matchIndexEnd = matcher.end();
                int proposedLineLength = 0;
                proposedLineLength = this.wrapBeforeRegExMatch ? matchIndexStart - currLineEnd : matchIndexEnd - currLineEnd;
                System.out.println("proposedLineLength = " + proposedLineLength);
                if (proposedLineLength < this.wrapLength && !this.wrapOnRegExAlways) continue;
                System.out.println("\tWrapping");
                if (this.wrapAtPreviousMatch) {
                    if (this.wrapBeforeRegExMatch) {
                        newText.append(unbrokenLine.substring(currLineEnd, lastMatchIndexStart)).append("\n").append(unbrokenLine.substring(lastMatchIndexStart, lastMatchIndexEnd));
                    } else {
                        newText.append(unbrokenLine.substring(currLineEnd, lastMatchIndexEnd)).append("\n");
                    }
                    currLineEnd = lastMatchIndexEnd;
                    continue;
                }
                if (this.wrapBeforeRegExMatch) {
                    newText.append(unbrokenLine.substring(currLineEnd, matchIndexStart)).append("\n").append(unbrokenLine.substring(matchIndexStart, matchIndexEnd));
                } else {
                    newText.append(unbrokenLine.substring(currLineEnd, matchIndexEnd)).append("\n");
                }
                currLineEnd = matchIndexEnd;
            }
            if (unbrokenLine.substring(currLineEnd).trim().equals("")) continue;
            newText.append(unbrokenLine.substring(currLineEnd)).append("\n");
        }
        if (newText.charAt(newText.length() - 1) == '\n') {
            newText.deleteCharAt(newText.length() - 1);
        }
        toTransform.setValue(newText);
        return used;
    }

    public abstract Pattern getRegex();
}

