/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util.wrapper;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.ebi.kraken.util.wrapper.Rule;
import uk.ac.ebi.kraken.util.wrapper.SimpleTextHolder;

public class PullLongEvidenceLineToPreviousLineRule
implements Rule<SimpleTextHolder> {
    public static final Pattern EV_PATTERN = Pattern.compile("\\n[\\w\\s]+\\{[\\w]+[0-9]+(,[\\w]+[0-9]+)*\\}");

    @Override
    public boolean transform(SimpleTextHolder toTransform) {
        StringBuilder text = toTransform.getValue();
        StringBuilder newText = new StringBuilder();
        boolean used = false;
        int patternStart = 0;
        int lastPatEnd = 0;
        Matcher matcher = EV_PATTERN.matcher(text.toString());
        while (matcher.find()) {
            patternStart = matcher.start();
            int evidenceEnd = matcher.end();
            int evCount = 1;
            for (int i = evidenceEnd - 1; text.charAt(i) != '{' && i > patternStart; --i) {
                if (text.charAt(i) != ',') continue;
                ++evCount;
            }
            if (evCount >= 10 && text.charAt(patternStart) == '\n') {
                newText.append(text.substring(lastPatEnd, patternStart)).append(text.substring(patternStart + 1, matcher.end()));
                used = true;
            } else {
                newText.append(text.substring(lastPatEnd, matcher.end()));
            }
            lastPatEnd = matcher.end();
        }
        if (lastPatEnd != text.length()) {
            newText.append(text.substring(lastPatEnd));
        }
        toTransform.setValue(newText);
        return used;
    }
}

