/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util.parser;

import java.util.HashMap;
import java.util.Map;
import uk.ac.ebi.kraken.util.GreekAlphabetConvertor;

public class ReplaceHTMLSymbolParser {
    private static final Map<String, String> HTML_SYMBOL_MAP = new HashMap<String, String>();
    private static final Map<String, String> HTML_SYMBOL_MAP_NO_SEMI = new HashMap<String, String>();
    private static final Map<String, String> HTML_SYMBOL_MAP_HEX = new HashMap<String, String>();

    public static String parse(String text) {
        if (text == null) {
            return text;
        }
        String val = text;
        val = GreekAlphabetConvertor.replaceCharactors(val, HTML_SYMBOL_MAP);
        val = GreekAlphabetConvertor.replaceCharactors(val, HTML_SYMBOL_MAP_NO_SEMI);
        val = GreekAlphabetConvertor.replaceCharactors(val, HTML_SYMBOL_MAP_HEX);
        val = val.replaceAll("&#[0-9]+;|&#[0-9]+", "");
        return val;
    }

    static {
        HTML_SYMBOL_MAP.put("&#65288;", "(");
        HTML_SYMBOL_MAP.put("&#65289;", ")");
        HTML_SYMBOL_MAP.put("&#65307;", ";");
        HTML_SYMBOL_MAP_NO_SEMI.put("&#65288", "(");
        HTML_SYMBOL_MAP_NO_SEMI.put("&#65289", ")");
        HTML_SYMBOL_MAP_NO_SEMI.put("&#65307", ";");
        HTML_SYMBOL_MAP_HEX.put("%2C", ",");
        HTML_SYMBOL_MAP_HEX.put("%7C", "|");
        HTML_SYMBOL_MAP_HEX.put("%3B", ";");
        HTML_SYMBOL_MAP_HEX.put("%3D", "=");
    }
}

