/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageDigestUtil {
    static final Logger LOG = LoggerFactory.getLogger(MessageDigestUtil.class);
    static final byte[] HEX_CHAR_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

    private MessageDigestUtil() {
    }

    public static String getDigest(String seq, String type) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance(type);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.info("provider for algorithm {} is not found", (Object)type, (Object)e);
            return seq;
        }
        byte[] input = seq.getBytes();
        byte[] output = md.digest(input);
        return MessageDigestUtil.byteArrayToHexString(output);
    }

    public static String getDigest(byte[] input, String type) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance(type);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
        byte[] output = md.digest(input);
        return MessageDigestUtil.byteArrayToHexString(output);
    }

    public static String getMD5(String seq) {
        return MessageDigestUtil.getDigest(seq, "MD5");
    }

    private static String byteArrayToHexString(byte[] in) {
        byte ch = 0;
        if (in == null || in.length <= 0) {
            return null;
        }
        String[] pseudo = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
        StringBuilder out = new StringBuilder(in.length * 2);
        for (int i = 0; i < in.length; ++i) {
            ch = (byte)(in[i] & 0xF0);
            ch = (byte)(ch >>> 4);
            ch = (byte)(ch & 0xF);
            out.append(pseudo[ch]);
            ch = (byte)(in[i] & 0xF);
            out.append(pseudo[ch]);
        }
        return new String(out);
    }
}

