/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class GreekAlphabetConvertor {
    private static Map<String, String> greekCharMap = new HashMap<String, String>();
    private static Map<String, String> greekHtmlCharMap = new HashMap<String, String>();
    private static Map<String, String> greekHtmlCharMapWithSemiColon = new HashMap<String, String>();

    private GreekAlphabetConvertor() {
    }

    public static String replaceAllGreekChars(String val) {
        return GreekAlphabetConvertor.replaceCharactors(val, greekCharMap);
    }

    public static String replaceAllGreekHtmlChars(String val) {
        if (val == null) {
            return val;
        }
        if (!val.contains("&#")) {
            return val;
        }
        String replaced = GreekAlphabetConvertor.replaceCharactors(val, greekHtmlCharMapWithSemiColon);
        return GreekAlphabetConvertor.replaceCharactors(replaced, greekHtmlCharMap);
    }

    public static String replaceCharactors(String val, Map<String, String> charMap) {
        if (val == null) {
            return val;
        }
        String result = val;
        List items = charMap.entrySet().stream().filter(entry -> result.contains((CharSequence)entry.getKey())).collect(Collectors.toList());
        String val1 = val;
        for (Map.Entry item : items) {
            String pId = (String)item.getKey();
            String tId = (String)item.getValue();
            val1 = val1.replaceAll(pId, tId);
        }
        return val1;
    }

    static {
        greekCharMap.put("\u03b1", "alpha");
        greekCharMap.put("\u03b2", "beta");
        greekCharMap.put("\u03b3", "gamma");
        greekCharMap.put("\u03b4", "delta");
        greekCharMap.put("\u03b5", "epsilon");
        greekCharMap.put("\u03b6", "zeta");
        greekCharMap.put("\u03b7", "eta");
        greekCharMap.put("\u03b8", "theta");
        greekCharMap.put("\u03b9", "iota");
        greekCharMap.put("\u03ba", "kappa");
        greekCharMap.put("\u03bb", "lambda");
        greekCharMap.put("\u03bc", "mu");
        greekCharMap.put("\u03bd", "nu");
        greekCharMap.put("\u03be", "xi");
        greekCharMap.put("\u03bf", "omicron");
        greekCharMap.put("\u03c0", "pi");
        greekCharMap.put("\u03c3", "sigma");
        greekCharMap.put("\u03c4", "tau");
        greekCharMap.put("\u03c5", "upsilon");
        greekCharMap.put("\u03c6", "phi");
        greekCharMap.put("\u03c7", "chi");
        greekCharMap.put("\u03c8", "psi");
        greekCharMap.put("\u03c9", "omega");
        greekHtmlCharMap.put("&#913", "alpha");
        greekHtmlCharMap.put("&#x391", "alpha");
        greekHtmlCharMap.put("&#945", "alpha");
        greekHtmlCharMap.put("&#x3b1", "alpha");
        greekHtmlCharMap.put("&#914", "beta");
        greekHtmlCharMap.put("&#x392", "beta");
        greekHtmlCharMap.put("&#946", "beta");
        greekHtmlCharMap.put("&#946", "beta");
        greekHtmlCharMap.put("&#915", "gamma");
        greekHtmlCharMap.put("&#x393", "gamma");
        greekHtmlCharMap.put("&#947", "gamma");
        greekHtmlCharMap.put("&#947", "gamma");
        greekHtmlCharMap.put("&#916", "delta");
        greekHtmlCharMap.put("&#x394", "delta");
        greekHtmlCharMap.put("&#948", "delta");
        greekHtmlCharMap.put("&#x3b4", "delta");
        greekHtmlCharMap.put("&#917", "epsilon");
        greekHtmlCharMap.put("&#x395;", "epsilon");
        greekHtmlCharMap.put("&#949", "epsilon");
        greekHtmlCharMap.put("&#x3b5", "epsilon");
        greekHtmlCharMap.put("&#918", "zeta");
        greekHtmlCharMap.put("&#x396", "zeta");
        greekHtmlCharMap.put("&#950", "zeta");
        greekHtmlCharMap.put("&#x3b6", "zeta");
        greekHtmlCharMap.put("&#919", "eta");
        greekHtmlCharMap.put("&#x397", "eta");
        greekHtmlCharMap.put("&#951", "eta");
        greekHtmlCharMap.put("&#x3b7", "eta");
        greekHtmlCharMap.put("&#920", "theta");
        greekHtmlCharMap.put("&#x398", "theta");
        greekHtmlCharMap.put("&#952", "theta");
        greekHtmlCharMap.put("&#x3b8", "theta");
        greekHtmlCharMap.put("&#921", "iota");
        greekHtmlCharMap.put("&#x399", "iota");
        greekHtmlCharMap.put("&#953", "iota");
        greekHtmlCharMap.put("&#x3b9", "iota");
        greekHtmlCharMap.put("&#922", "kappa");
        greekHtmlCharMap.put("&#x39a", "kappa");
        greekHtmlCharMap.put("&#954", "kappa");
        greekHtmlCharMap.put("&#x3ba", "kappa");
        greekHtmlCharMap.put("&#923", "lambda");
        greekHtmlCharMap.put("&#x39b", "lambda");
        greekHtmlCharMap.put("&#955", "lambda");
        greekHtmlCharMap.put("&#x3bb", "lambda");
        greekHtmlCharMap.put("&#924", "mu");
        greekHtmlCharMap.put("&#x39c", "mu");
        greekHtmlCharMap.put("&#956", "mu");
        greekHtmlCharMap.put("&#x3bc", "mu");
        greekHtmlCharMap.put("&#925", "nu");
        greekHtmlCharMap.put("&#x39d", "nu");
        greekHtmlCharMap.put("&#957", "nu");
        greekHtmlCharMap.put("&#x3bd", "nu");
        greekHtmlCharMap.put("&#926", "xi");
        greekHtmlCharMap.put("&#x39e", "xi");
        greekHtmlCharMap.put("&#958", "xi");
        greekHtmlCharMap.put("&#x3be", "xi");
        greekHtmlCharMap.put("&#927", "omicron");
        greekHtmlCharMap.put("&#x39f", "omicron");
        greekHtmlCharMap.put("&#959", "omicron");
        greekHtmlCharMap.put("&#x3bf", "omicron");
        greekHtmlCharMap.put("&#92", "pi");
        greekHtmlCharMap.put("&#x3a0", "pi");
        greekHtmlCharMap.put("&#960", "pi");
        greekHtmlCharMap.put("&#x3c0", "pi");
        greekHtmlCharMap.put("&#931", "sigma");
        greekHtmlCharMap.put("&#x3a3", "sigma");
        greekHtmlCharMap.put("&#963", "sigma");
        greekHtmlCharMap.put("&#x3c3", "sigma");
        greekHtmlCharMap.put("&#932", "tau");
        greekHtmlCharMap.put("&#x3a4", "tau");
        greekHtmlCharMap.put("&#964", "tau");
        greekHtmlCharMap.put("&#x3c4", "tau");
        greekHtmlCharMap.put("&#933", "upsilon");
        greekHtmlCharMap.put("&#x3a5", "upsilon");
        greekHtmlCharMap.put("&#96", "upsilon");
        greekHtmlCharMap.put("&#x3c5", "upsilon");
        greekHtmlCharMap.put("&#934", "phi");
        greekHtmlCharMap.put("&#x3a6", "phi");
        greekHtmlCharMap.put("&#966", "phi");
        greekHtmlCharMap.put("&#x3c6", "phi");
        greekHtmlCharMap.put("&#935", "chi");
        greekHtmlCharMap.put("&#x3a7", "chi");
        greekHtmlCharMap.put("&#967", "chi");
        greekHtmlCharMap.put("&#x3c7", "chi");
        greekHtmlCharMap.put("&#936", "psi");
        greekHtmlCharMap.put("&#x3a8", "psi");
        greekHtmlCharMap.put("&#968", "psi");
        greekHtmlCharMap.put("&#x3c8", "psi");
        greekHtmlCharMap.put("&#937", "omega");
        greekHtmlCharMap.put("&#x3a9", "omega");
        greekHtmlCharMap.put("&#969", "omega");
        greekHtmlCharMap.put("&#x3c9", "omega");
        greekHtmlCharMapWithSemiColon.put("&#913;", "alpha");
        greekHtmlCharMapWithSemiColon.put("&#x391;", "alpha");
        greekHtmlCharMapWithSemiColon.put("&#945;", "alpha");
        greekHtmlCharMapWithSemiColon.put("&#x3b1;", "alpha");
        greekHtmlCharMapWithSemiColon.put("&#914;", "beta");
        greekHtmlCharMapWithSemiColon.put("&#x392;", "beta");
        greekHtmlCharMapWithSemiColon.put("&#946;", "beta");
        greekHtmlCharMapWithSemiColon.put("&#946;", "beta");
        greekHtmlCharMapWithSemiColon.put("&#915;", "gamma");
        greekHtmlCharMapWithSemiColon.put("&#x393;", "gamma");
        greekHtmlCharMapWithSemiColon.put("&#947;", "gamma");
        greekHtmlCharMapWithSemiColon.put("&#947;", "gamma");
        greekHtmlCharMapWithSemiColon.put("&#916;", "delta");
        greekHtmlCharMapWithSemiColon.put("&#x394;", "delta");
        greekHtmlCharMapWithSemiColon.put("&#948;", "delta");
        greekHtmlCharMapWithSemiColon.put("&#x3b4;", "delta");
        greekHtmlCharMapWithSemiColon.put("&#917;", "epsilon");
        greekHtmlCharMapWithSemiColon.put("&#x395;;", "epsilon");
        greekHtmlCharMapWithSemiColon.put("&#949;", "epsilon");
        greekHtmlCharMapWithSemiColon.put("&#x3b5;", "epsilon");
        greekHtmlCharMapWithSemiColon.put("&#918;", "zeta");
        greekHtmlCharMapWithSemiColon.put("&#x396;", "zeta");
        greekHtmlCharMapWithSemiColon.put("&#950;", "zeta");
        greekHtmlCharMapWithSemiColon.put("&#x3b6;", "zeta");
        greekHtmlCharMapWithSemiColon.put("&#919;", "eta");
        greekHtmlCharMapWithSemiColon.put("&#x397;", "eta");
        greekHtmlCharMapWithSemiColon.put("&#951;", "eta");
        greekHtmlCharMapWithSemiColon.put("&#x3b7;", "eta");
        greekHtmlCharMapWithSemiColon.put("&#920;", "theta");
        greekHtmlCharMapWithSemiColon.put("&#x398;", "theta");
        greekHtmlCharMapWithSemiColon.put("&#952;", "theta");
        greekHtmlCharMapWithSemiColon.put("&#x3b8;", "theta");
        greekHtmlCharMapWithSemiColon.put("&#921;", "iota");
        greekHtmlCharMapWithSemiColon.put("&#x399;", "iota");
        greekHtmlCharMapWithSemiColon.put("&#953;", "iota");
        greekHtmlCharMapWithSemiColon.put("&#x3b9;", "iota");
        greekHtmlCharMapWithSemiColon.put("&#922;", "kappa");
        greekHtmlCharMapWithSemiColon.put("&#x39a;", "kappa");
        greekHtmlCharMapWithSemiColon.put("&#954;", "kappa");
        greekHtmlCharMapWithSemiColon.put("&#x3ba;", "kappa");
        greekHtmlCharMapWithSemiColon.put("&#923;", "lambda");
        greekHtmlCharMapWithSemiColon.put("&#x39b;", "lambda");
        greekHtmlCharMapWithSemiColon.put("&#955;", "lambda");
        greekHtmlCharMapWithSemiColon.put("&#x3bb;", "lambda");
        greekHtmlCharMapWithSemiColon.put("&#924;", "mu");
        greekHtmlCharMapWithSemiColon.put("&#x39c;", "mu");
        greekHtmlCharMapWithSemiColon.put("&#956;", "mu");
        greekHtmlCharMapWithSemiColon.put("&#x3bc;", "mu");
        greekHtmlCharMapWithSemiColon.put("&#925;", "nu");
        greekHtmlCharMapWithSemiColon.put("&#x39d;", "nu");
        greekHtmlCharMapWithSemiColon.put("&#957;", "nu");
        greekHtmlCharMapWithSemiColon.put("&#x3bd;", "nu");
        greekHtmlCharMapWithSemiColon.put("&#926;", "xi");
        greekHtmlCharMapWithSemiColon.put("&#x39e;", "xi");
        greekHtmlCharMapWithSemiColon.put("&#958;", "xi");
        greekHtmlCharMapWithSemiColon.put("&#x3be;", "xi");
        greekHtmlCharMapWithSemiColon.put("&#927;", "omicron");
        greekHtmlCharMapWithSemiColon.put("&#x39f;", "omicron");
        greekHtmlCharMapWithSemiColon.put("&#959;", "omicron");
        greekHtmlCharMapWithSemiColon.put("&#x3bf;", "omicron");
        greekHtmlCharMapWithSemiColon.put("&#92;", "pi");
        greekHtmlCharMapWithSemiColon.put("&#x3a0;", "pi");
        greekHtmlCharMapWithSemiColon.put("&#960;", "pi");
        greekHtmlCharMapWithSemiColon.put("&#x3c0;", "pi");
        greekHtmlCharMapWithSemiColon.put("&#931;", "sigma");
        greekHtmlCharMapWithSemiColon.put("&#x3a3;", "sigma");
        greekHtmlCharMapWithSemiColon.put("&#963;", "sigma");
        greekHtmlCharMapWithSemiColon.put("&#x3c3;", "sigma");
        greekHtmlCharMapWithSemiColon.put("&#932;", "tau");
        greekHtmlCharMapWithSemiColon.put("&#x3a4;", "tau");
        greekHtmlCharMapWithSemiColon.put("&#964;", "tau");
        greekHtmlCharMapWithSemiColon.put("&#x3c4;", "tau");
        greekHtmlCharMapWithSemiColon.put("&#933;", "upsilon");
        greekHtmlCharMapWithSemiColon.put("&#x3a5;", "upsilon");
        greekHtmlCharMapWithSemiColon.put("&#96;", "upsilon");
        greekHtmlCharMapWithSemiColon.put("&#x3c5;", "upsilon");
        greekHtmlCharMapWithSemiColon.put("&#934;", "phi");
        greekHtmlCharMapWithSemiColon.put("&#x3a6;", "phi");
        greekHtmlCharMapWithSemiColon.put("&#966;", "phi");
        greekHtmlCharMapWithSemiColon.put("&#x3c6;", "phi");
        greekHtmlCharMapWithSemiColon.put("&#935;", "chi");
        greekHtmlCharMapWithSemiColon.put("&#x3a7;", "chi");
        greekHtmlCharMapWithSemiColon.put("&#967;", "chi");
        greekHtmlCharMapWithSemiColon.put("&#x3c7;", "chi");
        greekHtmlCharMapWithSemiColon.put("&#936;", "psi");
        greekHtmlCharMapWithSemiColon.put("&#x3a8;", "psi");
        greekHtmlCharMapWithSemiColon.put("&#968;", "psi");
        greekHtmlCharMapWithSemiColon.put("&#x3c8;", "psi");
        greekHtmlCharMapWithSemiColon.put("&#937;", "omega");
        greekHtmlCharMapWithSemiColon.put("&#x3a9;", "omega");
        greekHtmlCharMapWithSemiColon.put("&#969;", "omega");
        greekHtmlCharMapWithSemiColon.put("&#x3c9;", "omega");
    }
}

