/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class AccessionResolver {
    private static final String UNIPROT_ACC_NEW_REX = "([O,P,Q][0-9][A-Z, 0-9]{3}[0-9]|[A-N,R-Z]([0-9][A-Z][A-Z, 0-9]{2}){1,2}[0-9])(-\\d+)*";
    private static final String UNIPROT_ID_REX = "([a-z0-9]{1,10}_[a-z0-9]{3,5})(-\\d+)*";
    private static final String UNIPARC_ACC_REX = "^UPI\\w{10}";
    private static final String UNIREF_ACC_REX = "^UNIREF100\\_.{6,16}+|^UNIREF90\\_.{6,16}+|^UNIREF50\\_.{6,16}+";
    private static final Pattern UNIPROT_ACC_PATTERN = Pattern.compile("([O,P,Q][0-9][A-Z, 0-9]{3}[0-9]|[A-N,R-Z]([0-9][A-Z][A-Z, 0-9]{2}){1,2}[0-9])(-\\d+)*", 2);
    private static final Pattern UNIPROT_ID_PATTERN = Pattern.compile("([a-z0-9]{1,10}_[a-z0-9]{3,5})(-\\d+)*", 2);
    private static final Pattern UNIPARC_ACC_PATTERN = Pattern.compile("^UPI\\w{10}", 2);
    private static final Pattern UNIREF_ACC_PATTERN = Pattern.compile("^UNIREF100\\_.{6,16}+|^UNIREF90\\_.{6,16}+|^UNIREF50\\_.{6,16}+", 2);
    private static final String INTERPRO_ACC_REX = "^IPR\\d{6}";
    private static final String GO_ACC_REX = "^GO\\:\\d{7}";
    private static final Pattern INTERPRO_ACC_PATTERN = Pattern.compile("^IPR\\d{6}", 2);
    private static final Pattern GO_ACC_PATTERN = Pattern.compile("^GO\\:\\d{7}", 2);

    private AccessionResolver() {
    }

    public static boolean isUniprotAccession(String acc) {
        Matcher matcher = UNIPROT_ACC_PATTERN.matcher(acc);
        return matcher.matches();
    }

    public static boolean isUniprotID(String acc) {
        Matcher matcher = UNIPROT_ID_PATTERN.matcher(acc);
        return matcher.matches();
    }

    public static boolean isUniparcAccession(String acc) {
        Matcher matcher = UNIPARC_ACC_PATTERN.matcher(acc);
        return matcher.matches();
    }

    public static boolean isUnirefAccession(String acc) {
        Matcher matcher = UNIREF_ACC_PATTERN.matcher(acc);
        return matcher.matches();
    }

    public static boolean isInterProAccession(String acc) {
        Matcher matcher = INTERPRO_ACC_PATTERN.matcher(acc);
        return matcher.matches();
    }

    public static boolean isGoAccession(String acc) {
        Matcher matcher = GO_ACC_PATTERN.matcher(acc);
        return matcher.matches();
    }
}

