/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.parser.translator;

import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Cofactor;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CofactorCommentStructured;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CofactorNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CofactorReference;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CofactorReferenceType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.kraken.parser.translator.CommentTranslator;
import uk.ac.ebi.kraken.parser.translator.CommentTranslatorHelper;

public class CofactorCommentTranslator
implements CommentTranslator<CofactorCommentStructured> {
    private static final String NOTE = "Note=";
    private static final String COLON = ":";
    private static final String SEMI_COLON = ";";
    private static final String EVIDENCE = "Evidence=";
    private static final DefaultCommentFactory FACTORY = DefaultCommentFactory.getInstance();
    private static final CommentType COMMENT_TYPE = CommentType.COFACTOR;
    private static final String COFACTOR_NAME = "Name=";
    private static final String COFACTOR_XREF = "Xref=";
    private static final String COFACTOR_REGEX = "^(\\[[\\w/-]+(\\s[\\w/-]+)*\\]:)?(\\s*Name=(\\S+( \\S+)*); Xref=\\w+:\\S+;?( Evidence=\\{.+:.+\\};)?)*(\\s*Note=.+\\.?)?";
    private static final Pattern COFACTOR_PATTERN = Pattern.compile("^(\\[[\\w/-]+(\\s[\\w/-]+)*\\]:)?(\\s*Name=(\\S+( \\S+)*); Xref=\\w+:\\S+;?( Evidence=\\{.+:.+\\};)?)*(\\s*Note=.+\\.?)?");

    private static String extractCofactorMolecule(String molecule) {
        return molecule.substring(1, molecule.indexOf(COLON) - 1);
    }

    private static List<Cofactor> extractCofactorReferences(String xrefs) {
        ArrayList<Cofactor> cofactors = new ArrayList<Cofactor>();
        try (Scanner scanner = new Scanner(xrefs);){
            scanner.useDelimiter("Name=|Xref=");
            while (scanner.hasNext()) {
                String name = CommentTranslatorHelper.stripTrailing(scanner.next().trim(), SEMI_COLON);
                String ref = scanner.next().trim();
                String evidence = null;
                if (ref.contains(EVIDENCE)) {
                    evidence = ref.substring(ref.indexOf(EVIDENCE) + EVIDENCE.length());
                    ref = ref.substring(0, ref.indexOf(EVIDENCE)).trim();
                }
                ref = CommentTranslatorHelper.stripTrailing(ref, SEMI_COLON);
                int dbTypeSeperator = ref.indexOf(COLON);
                String dbType = ref.substring(0, dbTypeSeperator);
                String xref = ref.substring(dbTypeSeperator + 1, ref.length());
                CofactorReference reference = FACTORY.buildCofactorReference();
                reference.setCofactorReferenceType(CofactorReferenceType.typeOf(dbType));
                reference.setReferenceId(xref);
                Cofactor cofactor = DefaultCommentFactory.getInstance().buildCofactor();
                cofactor.setCofactorReference(reference);
                cofactor.setName(name);
                if (evidence != null) {
                    ArrayList<EvidenceId> evidences = new ArrayList<EvidenceId>();
                    CommentTranslatorHelper.stripEvidenceIds(evidence, evidences);
                    cofactor.setEvidenceIds(evidences);
                }
                cofactors.add(cofactor);
            }
        }
        return cofactors;
    }

    @Override
    public CofactorCommentStructured translate(String annotation) {
        CofactorCommentStructured comment = (CofactorCommentStructured)FACTORY.buildComment(CommentType.COFACTOR);
        annotation = CommentTranslatorHelper.trimCommentHeader(annotation, COMMENT_TYPE);
        this.translate(annotation, comment);
        return comment;
    }

    @Override
    public void translate(String annotation, CofactorCommentStructured comment) {
        Matcher matcher = COFACTOR_PATTERN.matcher(annotation = CommentTranslatorHelper.trimCommentHeader(annotation, COMMENT_TYPE));
        if (matcher.matches()) {
            int separatorIndex = annotation.indexOf(NOTE);
            if (separatorIndex != -1) {
                CofactorNote note = FACTORY.buildCofactorNote();
                String noteStr = annotation.substring(separatorIndex + NOTE.length(), annotation.length());
                note.setTexts(CommentTranslatorHelper.parseEvidencedValues(noteStr, true));
                comment.setNote(note);
                annotation = annotation.substring(0, separatorIndex).trim();
            }
            if ((separatorIndex = annotation.indexOf(COFACTOR_NAME)) != -1) {
                List<Cofactor> cofactors = CofactorCommentTranslator.extractCofactorReferences(annotation.substring(separatorIndex, annotation.length()));
                comment.setCofactors(cofactors);
                annotation = annotation.substring(0, separatorIndex).trim();
            }
            if (annotation.trim().length() > 0) {
                comment.setMolecule(CofactorCommentTranslator.extractCofactorMolecule(annotation));
            }
        } else {
            throw new IllegalArgumentException("Unable to convert annotation to COFACTOR comment: " + annotation);
        }
    }
}

