/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.features;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureId;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureSequence;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureType;
import uk.ac.ebi.kraken.interfaces.uniprot.features.VariantFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.VariantReport;
import uk.ac.ebi.kraken.model.factories.DefaultFeatureFactory;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.model.uniprot.features.FeatureImpl;
import uk.ac.ebi.kraken.util.NoNullElementsList;

public class VariantFeatureImpl
extends FeatureImpl
implements VariantFeature {
    private FeatureSequence originalSequence = DefaultFeatureFactory.getInstance().buildFeatureSequence();
    private List<FeatureSequence> alternativeSequences;
    private FeatureId featureId;
    private List<VariantReport> variantReports;

    public VariantFeatureImpl(VariantFeature feature) {
        super(feature);
        this.alternativeSequences = new NoNullElementsList<FeatureSequence>(new ArrayList());
        this.featureId = DefaultFeatureFactory.getInstance().buildFeatureId("");
        this.variantReports = new NoNullElementsList<VariantReport>(new ArrayList());
        if (feature.getOriginalSequence() != null) {
            this.originalSequence = DefaultFeatureFactory.getInstance().buildFeatureSequence(feature.getOriginalSequence());
        }
        this.alternativeSequences = new NoNullElementsList<FeatureSequence>(new ArrayList());
        if (feature.getFeatureId() != null) {
            this.featureId = DefaultFeatureFactory.getInstance().buildFeatureId(feature.getFeatureId());
        }
        this.variantReports = new NoNullElementsList<VariantReport>(new ArrayList());
        if (feature.getVariantReports() != null) {
            for (VariantReport variantReport : feature.getVariantReports()) {
                this.variantReports.add(DefaultFeatureFactory.getInstance().buildVariantReport(variantReport));
            }
        }
        if (feature.getAlternativeSequences() != null) {
            for (FeatureSequence featureSequence : feature.getAlternativeSequences()) {
                this.alternativeSequences.add(DefaultFeatureFactory.getInstance().buildFeatureSequence(featureSequence));
            }
        }
    }

    public VariantFeatureImpl() {
        this.alternativeSequences = new ArrayList<FeatureSequence>();
        this.featureId = DefaultFeatureFactory.getInstance().buildFeatureId("");
        this.variantReports = new ArrayList<VariantReport>();
    }

    @Override
    public FeatureType getType() {
        return FeatureType.VARIANT;
    }

    @Override
    public List<VariantReport> getVariantReports() {
        return this.variantReports;
    }

    @Override
    public void setVariantReports(List<VariantReport> someVariantReports) {
        if (someVariantReports == null) {
            throw new IllegalArgumentException();
        }
        this.variantReports = someVariantReports;
    }

    @Override
    public VariantReport getVariantReport() {
        if (this.variantReports.isEmpty()) {
            this.variantReports.add(DefaultUniProtFactory.getFeatureFactory().buildVariantReport());
        }
        return this.variantReports.get(0);
    }

    @Override
    public void setVariantReport(VariantReport report) {
        if (report == null) {
            throw new IllegalArgumentException();
        }
        if (!this.variantReports.isEmpty()) {
            this.variantReports.set(0, report);
        } else {
            this.variantReports.add(report);
        }
    }

    @Override
    public FeatureId getFeatureId() {
        return this.featureId;
    }

    @Override
    public boolean hasFeatureId() {
        if (this.featureId == null) {
            return false;
        }
        return !this.featureId.getValue().equals("");
    }

    @Override
    public void setFeatureId(FeatureId id) {
        this.featureId = id;
    }

    @Override
    public FeatureSequence getOriginalSequence() {
        return this.originalSequence;
    }

    @Override
    public void setOriginalSequence(FeatureSequence original) {
        if (original == null) {
            throw new IllegalArgumentException();
        }
        this.originalSequence = original;
    }

    @Override
    public List<FeatureSequence> getAlternativeSequences() {
        return this.alternativeSequences;
    }

    @Override
    public void setAlternativeSequences(List<FeatureSequence> alternative) {
        if (alternative == null) {
            throw new IllegalArgumentException();
        }
        this.alternativeSequences = alternative;
    }

    public String toString() {
        return "VariantFeatureImpl";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VariantFeatureImpl that = (VariantFeatureImpl)o;
        if (this.alternativeSequences != null ? !this.alternativeSequences.equals(that.alternativeSequences) : that.alternativeSequences != null) {
            return false;
        }
        if (this.featureId != null ? !this.featureId.equals(that.featureId) : that.featureId != null) {
            return false;
        }
        if (this.originalSequence != null ? !this.originalSequence.equals(that.originalSequence) : that.originalSequence != null) {
            return false;
        }
        return !(this.variantReports != null ? !this.variantReports.equals(that.variantReports) : that.variantReports != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.originalSequence != null ? this.originalSequence.hashCode() : 0);
        result = 29 * result + (this.alternativeSequences != null ? this.alternativeSequences.hashCode() : 0);
        result = 29 * result + (this.featureId != null ? this.featureId.hashCode() : 0);
        result = 29 * result + (this.variantReports != null ? this.variantReports.hashCode() : 0);
        return result;
    }
}

