/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.comments;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformName;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.factories.DefaultEvidenceFactory;
import uk.ac.ebi.kraken.util.NoNullElementsList;

public class IsoformNameImpl
implements IsoformName {
    private String value;
    private List<EvidenceId> evidenceIds;
    public long id;

    public IsoformNameImpl() {
        this.value = "";
    }

    public IsoformNameImpl(IsoformName copy) {
        if (copy == null) {
            throw new IllegalArgumentException();
        }
        this.value = copy.getValue();
        this.evidenceIds = new NoNullElementsList<EvidenceId>(new ArrayList());
        for (EvidenceId evidenceId : copy.getEvidenceIds()) {
            this.evidenceIds.add(DefaultEvidenceFactory.getInstance().buildEvidenceId(evidenceId.getValue()));
        }
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.value = value;
    }

    @Override
    public List<EvidenceId> getEvidenceIds() {
        if (this.evidenceIds == null) {
            this.evidenceIds = new ArrayList<EvidenceId>();
        }
        return this.evidenceIds;
    }

    @Override
    public void setEvidenceIds(List<EvidenceId> evidenceIds) {
        this.evidenceIds = evidenceIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IsoformNameImpl that = (IsoformNameImpl)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.evidenceIds != null && !this.evidenceIds.isEmpty() ? !this.evidenceIds.equals(that.evidenceIds) : that.evidenceIds != null && !that.evidenceIds.isEmpty()) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + (this.evidenceIds != null && !this.evidenceIds.isEmpty() ? this.evidenceIds.hashCode() : 0);
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }
}

